% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-ace.R
\name{appendAceCompleter}
\alias{appendAceCompleter}
\title{Add completer}
\usage{
appendAceCompleter(
  outputId,
  id,
  completer,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{outputId}{\link{character}: The element id of the first editor}

\item{id}{\link{list}: Completer id}

\item{completer}{\link{list}: Completer list}

\item{session}{\link{environment}: The Shiny session object for the editor (from the server function of the Shiny app).}
}
\value{
No return value, called for side effects
}
\description{
Add completer to editor.completers. Please refer to \url{https://ace.c9.io/api/interfaces/ace.Ace.Completer.html}
}
\examples{
if(interactive()){
    shinyEditor::appendAceCompleter(
       outputId = "editor",
       id = "custom_completer",
       completer = list(
          list(value = "function", caption = "function", meta = "keyword"),
          list(value = "if", caption = "if", meta = "keyword"),
          list(value = "else", caption = "else", meta = "keyword"),
          list(value = "for", caption = "for", meta = "keyword"),
          list(value = "while", caption = "while", meta = "keyword"),
          list(value = "console.log()", caption = "console.log", meta = "function"),
          list(value = "myCustomFunction()", caption = "myCustomFunction", meta = "custom")
       )
    )
}
}
