% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modal-functionality.R
\name{twModalDialog}
\alias{twModalDialog}
\title{Creates a Modal Dialog}
\usage{
twModalDialog(
  ui,
  close_id = "close",
  close_label = "Close",
  close_class = NA,
  submit_id = "submit",
  submit_label = "Submit",
  submit_class = NA,
  title = "Title of Modal",
  modal_id = "shiny-modal",
  modal_width = "max-w-lg"
)
}
\arguments{
\item{ui}{UI of the modal}

\item{close_id}{ID for the close button}

\item{close_label}{Label for the close button, can be a tagList of an icon
and the label}

\item{close_class}{classes for the close button, if NA default values will
be used}

\item{submit_id}{ID for the submit button}

\item{submit_label}{Label for the submit button, can be a tagList of an icon
and the label}

\item{submit_class}{classes for the submit button, if NA default values will
be used}

\item{title}{title of the modal}

\item{modal_id}{id of the modal, make sure the ID is identical to the one
used in twBtnOpenModal}

\item{modal_width}{optional class to define the modal width, eg \verb{max-w-4xl}
for a wider modal}
}
\value{
a list with a \code{shiny.tag} class
}
\description{
Creates a Modal Dialog
}
\examples{
ui <- div(
  use_tailwind(),
  class = "h-screen bg-stone-100 p-10",
  twBtnOpenModal(
    "open_modal", "Show Modal",
    btn_class = "px-5 py-2 bg-rose-500 hover:bg-rose-700 text-white cursor-pointer rounded-md"
  ),
  twModalDialog(p("Hello World"))
)

server <- function(input, output, session) {
  observeEvent(input$open_modal, {
    print("Modal Opened")
  })
  observeEvent(input$submit, {
    print("Modal Closed - Submitted")
  })
  observeEvent(input$close, {
    print("Modal Closed - Closed")
  })
}
if (interactive() == TRUE) shinyApp(ui, server)
}
