% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sgstar.R
\name{plot_sgstar}
\alias{plot_sgstar}
\title{Timeseries Plot for Model}
\usage{
plot_sgstar(formula)
}
\arguments{
\item{formula}{an object from the output from sgstar() function.}
}
\value{
returns output a list that shown line chart for each location.
}
\description{
Plotting line chart dataset and fit.values of the Seasonal GSTAR model.
}
\examples{
library(sgstar)
data("coords")
data("simulatedata")

#create weight matrix using distance inverse matrix

z<-dist(coords,method = "euclidean")
z <- as.matrix(z)

matriksd <- 1/z
matriksd[is.infinite(matriksd)] <- 0

matriksd_w <- matriksd / rowSums(as.data.frame(matriksd))

fit <- sgstar(data = simulatedata, w = matriksd_w, p = 2,ps = 1, s =4)
plot1 <- plot_sgstar(fit)



}
