% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traverse_path.R
\name{all_traverse_paths}
\alias{all_traverse_paths}
\alias{get_one_traverse_path}
\alias{plot_traverse_paths}
\title{All traverse paths of a sequence}
\usage{
all_traverse_paths(rules, p)

get_one_traverse_path(rules, p)

plot_traverse_paths(rules, p, type = c("all", "11|22", "12|21"))
}
\arguments{
\item{rules}{An \code{sfc_rules} object.}

\item{p}{An \code{sfc_sequence} sequence. \code{p} and \code{rules} should have the same universe base set.
Please provide \code{p} as a small sequence because the total number of all traverse paths might be very huge.}

\item{type}{If the value is \code{"11|22"}, it highlights the paths only via 1-1/2-2 corners. If the value is \code{"12|21"}, it highlights the paths
only via 1-2/2-1 corners.}
}
\value{
\code{all_traverse_paths()} returns a list of integer vectors.

\code{get_one_traverse_path()} returns an integer vector.
}
\description{
All traverse paths of a sequence
}
\details{
Given an input sequence with rotations, \code{all_traverse_paths()} lists all combinations of expansion
codes from the first letter to the last letter in \code{p} (i.e. all possible traverse paths).

\code{get_one_traverse_path()} returns one random traverse path.
}
\examples{
# expansion rules for the general 3x3 curves
p = SFC_RULES_3x3_COMBINED@rules$I[[3]]
get_one_traverse_path(SFC_RULES_3x3_COMBINED, p)
get_one_traverse_path(SFC_RULES_3x3_COMBINED, p)
get_one_traverse_path(SFC_RULES_3x3_COMBINED, p)
get_one_traverse_path(SFC_RULES_3x3_COMBINED, p)
# 
p = SFC_RULES_3x3_COMBINED@rules$I[[3]]
plot_traverse_paths(SFC_RULES_3x3_COMBINED, p)
plot_traverse_paths(SFC_RULES_3x3_COMBINED, p, type = "11|22")
plot_traverse_paths(SFC_RULES_3x3_COMBINED, p, type = "12|21")

# 2x2 curve
p = sfc_2x2("I", 11)
plot_traverse_paths(SFC_RULES_2x2, p)

# Peano curve
p = sfc_3x3_peano("I", 1)
plot_traverse_paths(SFC_RULES_3x3_PEANO, p)

# Meander curve
p = sfc_3x3_meander("I", 1)
plot_traverse_paths(SFC_RULES_3x3_MEANDER, p)
}
