% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfc_rules.R
\name{draw_rules_2x2}
\alias{draw_rules_2x2}
\alias{draw_rules_3x3_peano}
\alias{draw_rules_3x3_meander}
\title{Draw the expansion rules}
\usage{
draw_rules_2x2()

draw_rules_3x3_peano(flip = FALSE)

draw_rules_3x3_meander(flip = FALSE)
}
\arguments{
\item{flip}{Whether to use the "flipped" rules? For the Peano curve and the Meander curve, there is also a "fliiped" version
of the curve expansion rules. See the vignettes for details.}
}
\value{
No value is returned.
}
\description{
Draw the expansion rules
}
\details{
The expansion rules define how the curve is expanded from level-0 to level-1.
}
\examples{
draw_rules_2x2()
# the units in the main rules of the Peano curve are vertical
draw_rules_3x3_peano()
# the units in the flipped rules of the Peano curve are horizontal
draw_rules_3x3_peano(flip = TRUE)
# the units in the main rules of the Meander curve are "forward"
# i.e. the direction of the "wave" is the same as the direction of the curve
draw_rules_3x3_meander()
# the units in the flipped rules of the Meander curve are "backward"
draw_rules_3x3_meander(flip = TRUE)
}
