% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensmediation.R
\name{more.effects}
\alias{more.effects}
\title{Estimate additional natural direct and indirect effects based on an \code{"effectsMed"} object}
\usage{
more.effects(
  sensmed.object,
  conf.level = 0.95,
  covariates = NULL,
  alt.decomposition = FALSE,
  exp.value = NULL,
  control.value = NULL
)
}
\arguments{
\item{sensmed.object}{an object of class "effectsMed" for which additional effects are to be calculated.}

\item{conf.level}{the confidence level to be used for confidence intervals and uncertainty intervals.}

\item{covariates}{if conditional effects are to be estimated the list of covariate values (see \code{\link{sensmediation}}). Covariates not specified are marginalized over.}

\item{alt.decomposition}{logical indicating whether alternative definitions of the direct and indirect effects should be used (see \code{\link{sensmediation}}).}

\item{exp.value}{value of the exposure variable used as the exposure condition, default is to take the value stored in \code{sensmed.object}.}

\item{control.value}{value of the exposure variable used as the control (unexposed) condition, default is to take the value stored in \code{sensmed.object}.}
}
\value{
\code{more.effects} returns an object of class \code{"effectsMed"}, see the documentation for \code{\link{sensmediation}}
for information.
}
\description{
Takes an \code{"effectsMed"} object and estimates additional natural direct and indirect effects, with a sensitivity analysis using
the same sensitivity parameter as in the original analysis, without having to redo the optimization to find the estimated regression coefficients.
The effects to be estimated are regulated through the arguments \code{covariates}, \code{alt.decomposition}, \code{exp.value} and \code{control.value}
as described in the documentation for \code{\link{sensmediation}}. The confidence level used is regulated through the argument \code{conf.level}.
}
\examples{
\dontrun{

# Example with data from Riksstroke (the Swedish stroke register)

data(RSdata)

# Probit mediator and outcome models:
med.model <- glm(lowered.consc ~ AF + age.cat + sex, data = RSdata,
family = binomial(link = 'probit'))
out.model <- glm(cf.3mo ~ AF + lowered.consc + age.cat + sex, data = RSdata,
family = binomial(link = 'probit'))

# First we estimate marginal NIE, NDE with sensitivity analyses to mediator-outcome
# confounding:
sensmed <- sensmediation(med.model, out.model, exp.name = "AF1", med.name = "lowered.consc",
Rho = seq(0, 0.5, 0.1))

# Then we also estimate NIE, NDE conditional on male sex without reestimating the regression
# coefficients:
sensmed.cond <- more.effects(sensmed.object = sensmed, covariates = list(sex = 1))
summary(sensmed.cond)
plot(sensmed.cond)
}

}
\seealso{
\code{\link{sensmediation}}
}
\author{
Anita Lindmark
}
