% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http-fxns.R
\name{sensibo.pod.probe}
\alias{sensibo.pod.probe}
\title{Probe the last measurements sent by a given air conditioner (pod).
In a typical configuration, Sensibo Sky Remote send fresh data to the server every 90 seconds.}
\usage{
sensibo.pod.probe(pod, key = getOption("sensibo.key"))
}
\arguments{
\item{pod}{(character) Pod unique id.}

\item{key}{(character) API key from https://home.sensibo.com/me/api.}
}
\value{
A list with time, temperature and humidity values. A 'seconds since last send' field is also provided.
}
\description{
Probe the last measurements sent by a given air conditioner (pod).
In a typical configuration, Sensibo Sky Remote send fresh data to the server every 90 seconds.
}
\examples{
\dontrun{
# Assuming that a valid Sensibo Sky API Key was created on https://home.sensibo.com/me/api
# and added to a 'sensibo.sky' global option.
#
# options("sensibo.key" = <Your Sensibo API Key>)
 
## Getting the list of pods available to the user
pods.id <- sensibo.pods()

## Get thew most current data probed by the first pod
pod.fresh.data <- sensibo.pod.probe(pods.id[1])
}
}
