% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic_eigen_indices.R
\name{ppg_gesim}
\alias{ppg_gesim}
\title{Predetermined Proportional Gain Genomic Eigen Selection Index (PPG-GESIM)}
\usage{
ppg_gesim(pmat, gmat, Gamma, d, selection_intensity = 2.063)
}
\arguments{
\item{pmat}{Phenotypic variance-covariance matrix (n_traits x n_traits).}

\item{gmat}{Genotypic variance-covariance matrix (n_traits x n_traits).}

\item{Gamma}{Covariance between phenotypes and GEBVs (n_traits x n_traits).}

\item{d}{Numeric vector of desired proportional gains (length n_traits).
The ratios among elements define target gain proportions.}

\item{selection_intensity}{Selection intensity constant \eqn{k_I}
(default: 2.063 for 10\% selection).}
}
\value{
Object of class \code{"ppg_gesim"}, a list with:
\describe{
  \item{\code{summary}}{Data frame with coefficients and metrics.}
  \item{\code{b_y}}{Coefficients for phenotypic data.}
  \item{\code{b_gamma}}{Coefficients for GEBVs.}
  \item{\code{b_combined}}{Combined coefficient vector.}
  \item{\code{E_PG}}{Expected genetic gains per trait.}
  \item{\code{gain_ratios}}{Ratios of actual to desired gains (should be constant).}
  \item{\code{d}}{Original desired proportional gains (length t).}
  \item{\code{d_PG}}{Extended proportional gains (length 2t, includes GEBV targets).}
  \item{\code{sigma_I}}{Standard deviation of the index.}
  \item{\code{hI2}}{Index heritability.}
  \item{\code{rHI}}{Accuracy.}
  \item{\code{R_PG}}{Selection response.}
  \item{\code{lambda2}}{Leading eigenvalue.}
  \item{\code{implied_w}}{Implied economic weights.}
  \item{\code{U_PG}}{Restriction matrix ((2t-1) x 2t).}
  \item{\code{selection_intensity}}{Selection intensity used.}
}
}
\description{
Implements the PPG-GESIM which extends GESIM to enforce that genetic gains
are proportional to a user-specified vector d. Combines eigen approach with
predetermined gain proportions.
}
\details{
\strong{Eigenproblem (Section 8.5):}
\deqn{(\mathbf{T}_{PG} - \lambda_{PG}^2 \mathbf{I}_{2t})\boldsymbol{\beta}_{PG} = 0}

where:
\deqn{\mathbf{T}_{PG} = \mathbf{K}_{RG}\mathbf{\Phi}^{-1}\mathbf{A} + \mathbf{B}}
\deqn{\mathbf{B} = \boldsymbol{\delta}\boldsymbol{\varphi}^{\prime}}

\strong{Implied economic weights:}
\deqn{\mathbf{w}_{PG} = \mathbf{A}^{-1}[\mathbf{\Phi} + \mathbf{Q}_{PG}^{\prime}\mathbf{A}]\boldsymbol{\beta}_{PG}}

\strong{Selection response:}
\deqn{R_{PG} = k_I \sqrt{\boldsymbol{\beta}_{PG}^{\prime}\mathbf{\Phi}\boldsymbol{\beta}_{PG}}}

\strong{Expected genetic gain per trait:}
\deqn{\mathbf{E}_{PG} = k_I \frac{\mathbf{A}\boldsymbol{\beta}_{PG}}{\sqrt{\boldsymbol{\beta}_{PG}^{\prime}\mathbf{\Phi}\boldsymbol{\beta}_{PG}}}}
}
\examples{
\dontrun{
gmat <- gen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])
pmat <- phen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])

# Simulate GEBV covariance
Gamma <- gmat * 0.8

# Desired proportional gains (e.g., 2:1:3 ratio for first 3 traits)
d <- c(2, 1, 3, 1, 1, 1, 1)

result <- ppg_gesim(pmat, gmat, Gamma, d)
print(result)
print(result$gain_ratios) # Should be approximately constant
}
}
\references{
Ceron-Rojas, J. J., & Crossa, J. (2018). Linear Selection Indices in Modern
Plant Breeding. Springer International Publishing. Section 8.5.
}
