% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenotypic_indices.R
\name{base_index}
\alias{base_index}
\title{Base Index (Williams, 1962)}
\usage{
base_index(
  pmat,
  gmat,
  wmat,
  wcol = 1,
  selection_intensity = 2.063,
  compare_to_lpsi = TRUE,
  GAY = NULL
)
}
\arguments{
\item{pmat}{Phenotypic variance-covariance matrix (n_traits x n_traits)}

\item{gmat}{Genotypic variance-covariance matrix (n_traits x n_traits)}

\item{wmat}{Economic weights matrix (n_traits x k), or vector}

\item{wcol}{Weight column to use if wmat has multiple columns (default: 1)}

\item{selection_intensity}{Selection intensity constant (default: 2.063)}

\item{compare_to_lpsi}{Logical. If TRUE, compares Base Index efficiency to optimal LPSI (default: TRUE)}

\item{GAY}{Optional. Genetic advance of comparative trait for PRE calculation}
}
\value{
List with:
  \itemize{
    \item \code{summary} - Data frame with coefficients and metrics
    \item \code{b} - Vector of Base Index coefficients (equal to w)
    \item \code{w} - Named vector of economic weights
    \item \code{Delta_G} - Named vector of expected genetic gains per trait
    \item \code{lpsi_comparison} - Optional comparison with Smith-Hazel LPSI
  }
}
\description{
Implements the Base Index where coefficients are set equal to economic weights.
This is a simple, non-optimized approach that serves as a baseline comparison.

Unlike the Smith-Hazel index which requires matrix inversion, the Base Index
is computationally trivial and robust when covariance estimates are unreliable.
}
\details{
\strong{Mathematical Formulation:}

Index coefficients: \eqn{b = w}

The Base Index is appropriate when:
- Covariance estimates are unreliable
- Computational simplicity is required
- A baseline for comparison is needed
}
\examples{
\dontrun{
gmat <- gen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])
pmat <- phen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])
weights <- c(10, 8, 6, 4, 2, 1, 1)

result <- base_index(pmat, gmat, weights, compare_to_lpsi = TRUE)
print(result)
}
}
