% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{create_EPOCH}
\alias{create_EPOCH}
\title{Create the EPOCH variable}
\usage{
create_EPOCH(tbl, date_col, RFXSTDTC = "RFXSTDTC", RFXENDTC = "RFXENDTC")
}
\arguments{
\item{tbl}{a data frame with date class columns \code{RFXSTDTC} and \code{RFXENDTC} and
the column given in the \code{date_col} argument}

\item{date_col}{a string, the column name of the event date used to determine
the EPOCH; this column can either have a date class or a character class in
the YYYY-MM-DD format}

\item{RFXSTDTC}{a string, the date column to use for \code{RFXSTDTC}, default is
\code{"RFXSTDTC"}; this column can either have a date class or a character class in
the YYYY-MM-DD format}

\item{RFXENDTC}{a string, the date column to use for \code{RFXENDTC}, default is
\code{"RFXENDTC"}; this column can either have a date class or a character class in
the YYYY-MM-DD format}
}
\value{
a modified copy of \code{tbl} with the \code{EPOCH} column
}
\description{
Utilizes the EPOCH method from the SDTM spec: Missing when \code{--DTC} is blank;
equal to \code{'SCREENING'} if \code{--DTC} if before \code{RFXSTDTC}; equal to \code{'TREATMENT'}
if \code{--DTC} is on or after \code{RFXSTDTC} and on or before \code{RFXENDTC}; equal to
\code{'FOLLOW-UP'} if \code{--DTC} is after \code{RFXENDTC}.
}
\examples{
df <- data.frame(
  DTC = c("2023-08-01", "2023-08-02", "2023-08-03", "2023-08-04"),
  RFXSTDTC = rep("2023-08-02", 4),
  RFXENDTC = rep("2023-08-03", 4)
)
create_EPOCH(df, date_col = "DTC")

}
\seealso{
\code{\link[=create_BLFL]{create_BLFL()}}, \code{\link[=calc_DY]{calc_DY()}}
}
