% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_sdl_methods.R
\name{plot.sdlrm}
\alias{plot.sdlrm}
\title{Diagnostic Plots for the Modified Skew Discrete Laplace Regression}
\usage{
\method{plot}{sdlrm}(
  x,
  which = 1:4,
  type = c("quantile", "pearson", "response"),
  ask = prod(graphics::par("mfcol")) < length(which) && grDevices::dev.interactive(),
  pch = "+",
  lty = 2,
  ...
)
}
\arguments{
\item{x}{an object of class \code{"sdlrm"}, a result of a call to \code{\link{sdlrm}}.}

\item{which}{numeric; if a subset of the plots is required, specify a subset
of the numbers \code{1:6}.}

\item{type}{character; specifies which residual should be produced in the
envelope plot. The available options are \code{"quantile"} (default),
\code{"pearson"}, and \code{"response"} (raw residuals, y - mu).}

\item{ask}{logical; if \code{TRUE}, the user is asked before each plot.}

\item{pch, lty, ...}{graphical parameters (see \code{\link[graphics]{par}})}
}
\value{
\code{plot} method for \code{"\link{sdlrm}"} objects returns six types
    of diagnostic plots.
}
\description{
This function provides plots for diagnostic analysis of a modified skew discrete
    Laplace regression fit.
}
\details{
The \code{plot} method for \code{"\link{sdlrm}"} objects provides six types
    of diagnostic plots in the following order:
    \describe{
        \item{Residuals vs fitted values}{a plot of the residuals
            against fitted values.}
        \item{Residuals vs observation indices.}{an index plot of the residuals
            against  observation indices.}
        \item{Normal probability plot}{a normal probability plot of the residuals.}
        \item{Fitted vs observed frequencies}{a bar plot with comparisons of the observed
            and fitted frequencies.}
        \item{Sample autocorrelation plot}{sample autocorrelation function plot of the residuals.}
        \item{Sample partial autocorrelation plot}{sample partial autocorrelation function plot of the residuals.}
     }

     The \code{which} argument can be used to select a subset of the implemented plots.
     Default is \code{which = 1:4}.
}
\examples{
## Data set: pss (for description run ?pss)
barplot(table(pss$difference), xlab = "PSS index difference", ylab = "Frequency")
boxplot(pss$difference ~ pss$group, xlab = "Group", ylab = "PSS index difference")

## Fit with a model only for the mean (mode = 1)
fit <- sdlrm(difference ~ group, data = pss, xi = 1)

## Available plots (using the randomized quantile residuals):
# Residuals versus fitted values
plot(fit, which = 1)

# Residuals versus observation indices
plot(fit, which = 2)

# Normal Q-Q plot
plot(fit, which = 3)

# Observed versus fitted frequencies
plot(fit, which = 4)

# Sample autocorelation function of residuals
plot(fit, which = 5)

# Sample partial autocorelation of residuals
plot(fit, which = 6)
}
\author{
Francisco F. de Queiroz <\email{felipeq@ime.usp.br}>

Rodrigo M. R. de Medeiros <\email{rodrigo.matheus@ufrn.br}>
}
