% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_sdl_diagnostic.R
\name{envelope}
\alias{envelope}
\alias{print.envelope}
\alias{plot.envelope}
\title{Envelope Plot for the Residuals of a Modified Skew Discrete Laplace Regression Fit}
\usage{
envelope(object, nsim = 99, progressBar = TRUE, plot = TRUE, ...)

\method{print}{envelope}(x, ...)

\method{plot}{envelope}(x, type = c("quantile", "pearson"), level = 0.95, ...)
}
\arguments{
\item{object, x}{an object of class \code{"sdlrm"}, a result of a call to \code{\link{sdlrm}}.}

\item{nsim}{the number of replicates. The default is \code{nsim = 99}.}

\item{progressBar}{logical; if \code{TRUE}, a progress bar is displayed giving
the progress of making the graph. It can slow down the function
considerably in applications with a large sample size.}

\item{plot}{logical; if \code{TRUE}, the envelope plot of the residuals is displayed.}

\item{...}{further arguments passed to or from other methods.}

\item{type}{character; specifies which residual should be produced in the
envelope plot. The available options are \code{"quantile"} (default) and
\code{"pearson"} ((y - mean) / sd).}

\item{level}{level of the sample quantile of the residual used in the
construction of confidence bands.}
}
\value{
\code{envelope} returns an \code{"sdlrm_envel"} object which consists of
    a list with the following components:
\describe{
  \item{residuals}{a list with the quantile and pearson residuals resulting from the
      fit of the SDL regression model.}
  \item{simulation}{a list whose components are matrices containing the
      ordered quantile and pearson residuals of the simulation for the
      plot envelope.}

 The method \code{plot} makes the envelope plot.
 }
}
\description{
Provides the normal probability plot with simulated
    envelope of Pearson residuals and randomized quantile residuals
    resulting from the modified skew discrete Laplace (SDL) regression fit.
}
\examples{
## Data set: pss (for description run ?pss)
barplot(table(pss$difference), xlab = "PSS index difference", ylab = "Frequency")
boxplot(pss$difference ~ pss$group, xlab = "Group", ylab = "PSS index difference")

## Fit with a model only for the mean (mode = 1)
fit <- sdlrm(difference ~ group, data = pss, xi = 1)

## Building the envelope plot
envel <- envelope(fit, plot = FALSE)

# Class
class(envel)
envel

# Plot for the randomized quantile residuals (default)
plot(envel)

# Plot for the Pearson residuals
plot(envel, type = "pearson")
}
\references{
Medeiros, R. M. R., and Bourguignon, M. (2025). Modified skew discrete Laplace
    regression models for integer valued data with applications to paired samples.
    \emph{Manuscript submitted for publication.}
}
\author{
Rodrigo M. R. de Medeiros <\email{rodrigo.matheus@ufrn.br}>
}
