% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-cards.R
\name{scry-cards}
\alias{scry-cards}
\alias{scry_cards}
\alias{scry_card}
\alias{scry_card_name}
\alias{scry_card_number}
\alias{scry_card_random}
\title{Retrieve information about cards}
\usage{
scry_cards(
  q,
  unique = "cards",
  order = "name",
  dir = "auto",
  include_extras = FALSE,
  include_multilingual = FALSE,
  include_variations = FALSE,
  page = NULL
)

scry_card(id, source = "scryfall")

scry_card_name(name, mode = c("fuzzy", "exact"), set = NULL)

scry_card_number(number, set, lang = "en")

scry_card_random(q = NULL)
}
\arguments{
\item{q}{A search query using the same fulltext search system that Scryfall
uses. For more information see \code{vignette("syntax")}.}

\item{unique}{The strategy for omitting similar cards. The options are:
\itemize{
\item \code{cards}: Removes duplicate gameplay objects (cards that share a name and
have the same functionality). For example, if your search matches more than
one print of Pacifism, only one copy of Pacifism will be returned.
\item \code{art}: Returns only one copy of each unique artwork for matching cards. For
example, if your search matches more than one print of Pacifism, one card
with each different illustration for Pacifism will be returned, but any
cards that duplicate artwork already in the results will be omitted.
\item \code{prints}: Returns all prints for all cards matched (disables rollup). For
example, if your search matches more than one print of Pacifism, all
matching prints will be returned.
}}

\item{order}{The method to sort returned cards. The options are:
\itemize{
\item \code{name}: Sort cards by name, A -> Z.
\item \code{set}: Sort cards by their set and collector number: AAA/#1 -> ZZZ/#999.
\item \code{released}: Sort cards by their release date: Newest -> Oldest.
\item \code{rarity}: Sort cards by their rarity: Common -> Mythic.
\item \code{color}: Sort cards by their color and color identity: WUBRG -> multicolor
-> colorless.
\item \code{usd}: Sort cards by their lowest known U.S. Dollar price: 0.01 -> highest,
\code{NA} last.
\item \code{tix}: Sort cards by their lowest known TIX price: 0.01 -> highest, \code{NA}
last.
\item \code{eur}: Sort cards by their lowest known Euro price: 0.01 -> highest, \code{NA}
last.
\item \code{cmc}: Sort cards by their converted mana cost: 0 -> highest.
\item \code{power}: Sort cards by their power: \code{NA} -> highest.
\item \code{toughness}: Sort cards by their toughness: \code{NA} -> highest.
\item \code{edhrec}: Sort cards by their EDHREC ranking: lowest -> highest.
\item \code{artist}: Sort cards by their front-side artist name: A -> Z.
\item \code{review}: Sort cards how podcasts review sets, usually color & CMC, lowest
-> highest, with Booster Fun cards at the end.
}}

\item{dir}{The direction to sort cards. The options are:
\itemize{
\item \code{auto}: Scryfall will automatically choose the most intuitive direction to
sort.
\item \code{asc}: Sort ascending (the direction of the arrows in the previous
argument).
\item \code{desc}: Sort descending (flip the direction of the arrows in the previous
argument).
}}

\item{include_extras}{If \code{TRUE}, extra cards (tokens, planes, etc) will be
included. Equivalent to adding \code{include:extras} to the search query.}

\item{include_multilingual}{If \code{TRUE}, cards in every language supported by
Scryfall will be included.}

\item{include_variations}{If \code{TRUE}, rare care variants will be included,
like the
\href{https://scryfall.com/card/drk/107\%E2\%80\%A0/runesword}{Hairy Runesword}.}

\item{page}{The results' page number to return. If \code{NULL} (the default), all
available results will be returned.}

\item{id}{Unique card identifier. May refer to any supported \code{source}.}

\item{source}{Source to which \code{id} refers. Can be any one of \code{scryfall},
\code{multiverse}, \code{mtgo}, \code{arena}, \code{tcgplayer} or \code{cardmarket}.}

\item{name}{A string with a card's name (or part of it).}

\item{mode}{Search mode. Can be either \code{fuzzy} (\code{name} may be part of a
card's name, allows misspellings and partial words to be provided too) or
\code{exact} (\code{name} has to match exactly, case insensitive).}

\item{set}{The three to five-letter set code.}

\item{number}{The card's collector number for a set.}

\item{lang}{The 2-3 character language code. For more information, see
\code{vignette("languages")}}
}
\value{
A data frame with 1 or more rows and the following columns:
\itemize{
\item \code{id} [chr]: A unique ID for this card in Scryfall's database.
\item \code{name} [chr]: The name of this card. If this card has multiple faces,
this column will contain both names separated by \verb{␣//␣}.
\item \code{set} [chr]: This card's set code.
\item \code{lang} [chr]: A language code for this printing. For more information,
see \code{vignette("languages")}
\item \code{colors} [list]: This card's colors, if the overall card has colors
defined by the rules. Otherwise the colors will be on the \code{card_faces}
column, see below.
\item \code{color_identity} [list]: This card's color identity.
\item \code{color_indicator} [list]: The colors in this card's color indicator, if
any. A \code{NULL} value for this column indicates the card does not have one.
\item \code{mana_cost} [chr]: The mana cost for this card. This value will be any
empty string \code{""} if the cost is absent. Remember that per the game rules,
a missing mana cost and a mana cost of \code{{0}} are different values.
Multi-faced cards will report this value in \code{card_faces}, see below.
\item \code{cmc} [dbl]: The card's converted mana cost. Note that some funny cards
have fractional mana costs.
\item \code{oracle_text} [chr]: The Oracle text for this card, if any.
\item \code{power} [chr]: This card's power, if any. Note that some cards have
powers that are not numeric, such as \code{*}.
\item \code{toughness} [chr]: This card's toughness, if any. Note that some cards
have toughnesses that are not numeric, such as \code{*}.
\item \code{type_line} [chr]: The type line of this card.
\item \code{edhrec_rank} [int]: This card's overall rank/popularity on EDHREC. Not
all cards are ranked.
\item \code{hand_modifier} [chr]: This card's hand modifier, if it is Vanguard card.
This value will contain a delta, such as \code{-1}.
\item \code{keywords} [list]: A vector of keywords that this card uses, such as
\code{Flying} and \verb{Cumulative upkeep}.
\item \code{layout} [chr]: A code for this card's layout. For more information see
\code{vignette("layouts")}
\item \code{legalities} [list]: A data frame describing the legality of this card
across play formats. Possible legalities are \code{legal}, \code{not_legal},
\code{restricted}, and \code{banned}.
\item \code{life_modifier} [chr]: This card's life modifier, if it is Vanguard card.
This value will contain a delta, such as \code{+2}.
\item \code{loyalty} [chr]: This loyalty if any. Note that some cards have loyalties
that are not numeric, such as \code{X}.
\item \code{oversized} [lgl]: Whether this card is oversized.
\item \code{produced_mana} [list]: Colors of mana that this card could produce.
\item \code{reserved} [lgl]: Whether this card is on the Reserved List.
\item \code{oracle_id} [chr]: A unique ID for this card's oracle identity. This
value is consistent across reprinted card editions, and unique among
different cards with the same name (tokens, Unstable variants, etc).
\item \code{arena_id} [int]: This card's Arena ID, if any. A large percentage of
cards are not available on Arena and do not have this ID.
\item \code{mtgo_id}, \code{mtgo_foil_id} [int]: This card's Magic Online ID (also known
as the Catalog ID), if any. A large percentage of cards are not available
on Magic Online and do not have this ID.
\item \code{multiverse_ids} [list]: This card's multiverse IDs on Gatherer, if any,
as a vector of integers. Note that Scryfall includes many promo cards,
tokens, and other esoteric objects that do not have these identifiers.
\item \code{tcgplayer_id}, \code{tcgplayer_etched_id} [int]: This card's ID on
\href{https://docs.tcgplayer.com/docs}{TCGplayer's API}, also known as the
\code{productId}.
\item \code{cardmarket_id} [int]: This card's ID on Cardmarket's API, also known as
the \code{idProduct}.
\item \code{uri} [chr]: A link to this card on Scryfall's API.
\item \code{scryfall_uri} [chr]: A link to this card's permapage on Scryfall's
\item \code{rulings_uri} [chr]: A link to this card's rulings list on Scryfall's
API. For more information see \code{\link[=scry_ruling]{scry_ruling()}}
\item \code{prints_search_uri} [chr]: A link to where you can begin paginating all
re/prints for this card on Scryfall's API.
website.
\item \code{all_parts} [list]: If this card is closely related to other cards, this
column will be a data frame with the following columns:
\itemize{
\item \code{id} [chr]: An unique ID for this card in Scryfall's database.
\item \code{object} [chr]: A content type for this object, always \code{related_card}.
\item \code{component} [chr]: A column explaining what role this card plays in
this relationship, one of \code{token}, \code{meld_part}, \code{meld_result}, or
\code{combo_piece}.
\item \code{name} [chr]: The name of this particular related card.
\item \code{type_line} [chr]: The type line of this card.
\item \code{uri} [chr]: A URI where you can retrieve a full object describing this
card on Scryfall's API.
}
\item \code{card_faces} [list]: A data frame of card faces (if this card is
multifaced) with the following columns. For more information see
\code{vignette("layouts")}.
\itemize{
\item \code{name} [chr]: The name of this particular face.
\item \code{colors} [list]: This face's colors, if the game defines colors for the
individual face of this card.
\item \code{color_indicator} [list]: The colors in this face's color indicator, if
any.
\item \code{mana_cost} [chr]: The mana cost for this face. This value will be any
empty string \code{""} if the cost is absent. Remember that per the game
rules, a missing mana cost and a mana cost of \code{{0}} are different values.
\item \code{cmc} [dbl]: The mana value of this particular face, if the card is
reversible.
\item \code{oracle_text} [chr]: The Oracle text for this face, if any.
\item \code{power} [chr]: This face's power, if any. Note that some cards have
powers that are not numeric, such as \code{*}.
\item \code{toughness} [chr]: This face's toughness, if any.
\item \code{type_line} [chr]: The type line of this particular face, if the card
is reversible.
\item \code{layout} [chr]: The layout of this card face, if the card is
reversible.
\item \code{loyalty} [chr]: This face's loyalty, if any.
\item \code{oracle_id} [chr]: The Oracle ID of this particular face, if the card
is reversible.
\item \code{artist} [chr]: The name of the illustrator of this card face. Newly
spoiled cards may not have this column yet.
\item \code{artist_id} [chr]: This faces's illustrator's unique identifier.
\item \code{flavor_name} [chr]: The just-for-fun name printed on the card (such as
for Godzilla series cards).
\item \code{flavor_text} [chr]: The flavor text printed on this face, if any.
\item \code{illustration_id} [chr]: A unique identifier for the card face artwork
that remains consistent across reprints. Newly spoiled cards may not have
this column yet.
\item \code{image_uris} [list]: A data frame providing URIs to imagery for this
face, if this is a double-sided card. If this card is not double-sided,
then the \code{image_uris} column will be part of the parent object instead.
\item \code{printed_name} [chr]: The localized name printed on this face, if any.
\item \code{printed_text} [chr]: The localized text printed on this face, if any.
\item \code{printed_type_line} [chr]: The localized type line printed on this
face, if any.
\item \code{watermark} [chr]: The watermark on this particularly card face, if
any.
}
\item \code{artist} [chr]: The name of the illustrator of this card. Newly spoiled
cards may not have this column yet.
\item \code{booster} [lgl]: Whether this card is found in boosters.
\item \code{border_color} [chr]: This card's border color: \code{black}, \code{white},
\code{borderless}, \code{silver}, or \code{gold}.
\item \code{card_back_id} [chr]: The Scryfall ID for the card back design present on
this card.
\item \code{collector_number} [chr]: This card's collector number. Note that
collector numbers can contain non-numeric characters, such as letters or
stars.
\item \code{content_warning} [lgl]: \code{TRUE} if you should consider avoiding use of
this print downstream.
\item \code{digital} [lgl]: Whether this card was only released in a video game.
\item \code{finishes} [list]: A vector of computer-readable flags that indicate if
this card can come in \code{foil}, \code{nonfoil}, \code{etched}, or \code{glossy} finishes.
\item \code{flavor_name} [chr]: The just-for-fun name printed on the card (such as
for Godzilla series cards).
\item \code{flavor_text} [chr]: The flavor text, if any.
\item \code{frame_effects} [list]: This card's frame effects, if any. For more
information see \code{vignette("frames")}.
\item \code{frame} [chr]: This card's frame layout. For more information see
\code{vignette("frames")}.
\item \code{full_art} [lgl]: Whether this card's artwork is larger than normal.
\item \code{games} [list]: A vector of games that this card print is available in,
\code{paper}, \code{arena}, and/or \code{mtgo}.
\item \code{highres_image} [lgl]: Whether this card's imagery is high resolution.
\item \code{illustration_id} [chr]: A unique identifier for the card artwork that
remains consistent across reprints. Newly spoiled cards may not have this
column yet.
\item \code{image_status} [chr]: A computer-readable indicator for the state of this
card's image, one of \code{missing}, \code{placeholder}, \code{lowres}, or \code{highres_scan}.
\item \code{image_uris} [list]: A data frame listing available imagery for this
card. For more information see \code{vignette("imagery")}.
\item \code{preview} [list]: A data frame providing information about this card's
preview.
\item \code{prices} [list]: A data frame containing daily price information for this
card, including \code{usd}, \code{usd_foil}, \code{usd_etched}, \code{eur}, and \code{tix} prices,
as strings.
\item \code{printed_name} [chr]: The localized name printed on this card, if any.
\item \code{printed_text} [chr]: The localized text printed on this card, if any.
\item \code{printed_type_line} [chr]: The localized type line printed on this card,
if any.
\item \code{promo} [lgl]: Whether this card is a promotional print.
\item \code{promo_types} [list]: A vector of strings describing what categories of
promo cards this card falls into.
\item \code{purchase_uris} [list]: A data frame providing URIs to this card's
listing on major marketplaces.
\item \code{rarity} [chr]: This card's rarity. One of \code{common}, \code{uncommon}, \code{rare},
\code{special}, \code{mythic}, or \code{bonus}.
\item \code{related_uris} [list]: A data frame providing URIs to this card's listing
on other \emph{Magic: The Gathering} online resources.
\item \code{released_at} [date]: The date this card was first released.
\item \code{reprint} [lgl]: Whether this card is a reprint.
\item \code{scryfall_set_uri} [chr]: A link to this card's set on Scryfall's
website.
\item \code{set_name} [chr]: This card's full set name.
\item \code{set_search_uri} [chr]: A link to where you can begin paginating this
card's set on the Scryfall API.
\item \code{set_type} [chr]: The type of set this printing is in.
\item \code{set_uri} [chr]: A link to this card's set on Scryfall's API. For more
information see \code{?scry_sets()}.
\item \code{set_id} [chr]: This card's set Scryfall ID.
\item \code{story_spotlight} [lgl]: Whether this card is a Story Spotlight.
\item \code{textless} [lgl]: Whether the card is printed without text.
\item \code{variation} [lgl]: Whether this card is a variation of another printing.
\item \code{variation_of} [chr]: The printing ID of the printing this card is a
variation of.
\item \code{security_stamp} [chr]: The security stamp on this card, if any. One of
\code{oval}, \code{triangle}, \code{acorn}, or \code{arena}.
\item \code{watermark} [chr]: This card's watermark, if any.
}
}
\description{
Cards represent individual \emph{Magic: The Gathering} playing cards that players
could obtain and add to their collection (with a few minor exceptions).

Cards are the API's most complex object. You are encouraged to thoroughly
read this document and also \code{vignette("layouts")}.
}
\examples{
\donttest{
# Get all legendary vampires
scry_cards("t:vampire t:legend")

# Get card using an ID
scry_card("913dd06f-ed2f-4128-9c9d-9cd0d8a55425")

# Get card using a name
scry_card_name("Anje Falkenrath")

# Get card using a collector number and a set
scry_card_number(37, "c19")

# Just get a random legendary vampires
scry_card_random("t:vampire t:legend")
}

}
\references{
\url{https://scryfall.com/docs/api/cards}
}
