% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_dataline.R
\name{set_dataline}
\alias{set_dataline}
\alias{add_dataline}
\title{Set data lines of an scplot object}
\usage{
set_dataline(
  object,
  variable = NULL,
  line,
  point,
  type = "continuous",
  label = NULL,
  ...
)

add_dataline(...)
}
\arguments{
\item{object}{An scplot object (class \code{scplot}) returned from the \code{scplot()}
function.}

\item{variable}{String. The name of a new variable for adding a new line. If
left empty, the aesthetics of the default data line are changed.}

\item{line}{List with line parameters (\verb{"colour", "linewidth", "linetype", "lineend", "arrow"}). See \code{\link[=element_line]{element_line()}}.}

\item{point}{A list with point parameters (\verb{"colour", "size", "shape"}). See
\code{\link[=element_point]{element_point()}}.}

\item{type}{Either "continuous" or "discrete". Specifies how the data line
should be treated.}

\item{label}{A character string which is used to set the label in a legend.}

\item{...}{As a shortcut, arguments passed hear are bundled as \code{line}
arguments (see \code{\link[=element_line]{element_line()}}).}
}
\value{
An object of class \code{scplot} (see\code{\link[=scplot]{scplot()}}) with a changed \code{datalines}
element.
}
\description{
Either set aesthetics of the default data line or add another data line.
The function allows customization of data lines by passing arguments
similar to those used in \code{element_line()} and \code{element_point()}, such as
\code{color}, \code{size}, and \code{linetype}.
}
\details{
If \code{variable} is left empty or set to \code{".dvar"}, the aesthetics of the
default data line are changed. Otherwise, a new data line is added for the
specified variable.
}
\examples{
data(exampleAB_add, package = "scan")
scplot(exampleAB_add)  |>
  set_dataline("depression", color = "darkblue")
}
\seealso{
\code{\link[=element_line]{element_line()}}, \code{\link[=element_point]{element_point()}}
}
