% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_labels.R
\name{add_labels}
\alias{add_labels}
\title{Add value labels to an scplot}
\usage{
add_labels(
  object,
  nudge_y = 5,
  nudge_x = 0,
  round = NULL,
  text = list(),
  background = list(),
  variable = ".dvar",
  padding = NULL
)
}
\arguments{
\item{object}{An scplot object (class \code{scplot}) returned from the \code{scplot()}
function.}

\item{nudge_y}{Offset on the y-axis.}

\item{nudge_x}{Offset on the x-axis.}

\item{round}{Number of digits of the labels. If NULL, no rounding is applied.}

\item{text}{List with text parameters (\verb{"family", "face", "colour", "size", "hjust", "vjust", "angle", "lineheight", "margin"}). See \code{\link[=element_text]{element_text()}}.}

\item{background}{A list with background styling arguments (fill, color,
size, linetype).}

\item{variable}{Name of the dataline variable to apply the style.}

\item{padding}{Padding size around text.}
}
\value{
An object of class \code{scplot} (see\code{\link[=scplot]{scplot()}}) with added/changed element
\code{labels}.
}
\description{
This function adds value labels to an existing \code{scplot} object. The labels
display the values of a specified variable (default is \code{.dvar}, which
typically represents the main variable being plotted). You can customize the
position, rounding, text style, and background style of the labels.
}
