% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scperturbr.R
\name{edist}
\alias{edist}
\title{edist}
\usage{
edist(
  seurat_object,
  groupby = "perturbation",
  reduction = "pca",
  sample_correction = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{seurat_object}{An object of class Seurat.}

\item{groupby}{An object of class character. Points to the column in the
Seurat object's meta data that contains the group labels.}

\item{reduction}{An object of class character. The reduction / embedding in
seurat_object that is used to compute the E-distance in.}

\item{sample_correction}{An object of class logical. If TRUE, the
E-distances are corrected for sample size. Will make it not a proper
distance, leads to negative values.}

\item{verbose}{An object of class logical. If TRUE, prints messages.
Default is TRUE.}
}
\value{
Returns an object of class data.frame. For each group contains the
    E-test p-value and the E-distance to control group.
}
\description{
Computes pairwise E-distances on a Seurat object.
    Computes E-distance between all groups in a Seurat object in space
    given by reduction.
}
\examples{
    # Add some code illustrating how to use the function
}
