% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scf_ols.R
\name{scf_ols}
\alias{scf_ols}
\title{Estimate an Ordinary Least Squares Regression on SCF Microdata}
\usage{
scf_ols(object, formula)
}
\arguments{
\item{object}{A \code{scf_mi_survey} object created with \code{\link[=scf_load]{scf_load()}} and \code{\link[=scf_design]{scf_design()}}. Must contain five implicates with replicate weights.}

\item{formula}{A model formula specifying a continuous outcome and predictor variables (e.g., \code{networth ~ income + age}).}
}
\value{
An object of class \code{"scf_ols"} and \code{"scf_model_result"} with:
\describe{
\item{results}{A data frame of pooled coefficients, standard errors, t-values, p-values, and significance stars.}
\item{fit}{A list of model diagnostics including mean AIC, standard deviation of AIC, mean R-squared, and its standard deviation.}
\item{imps}{A list of implicate-level \code{svyglm} model objects.}
\item{call}{The matched call used to produce the model.}
}
}
\description{
Computes an OLS regression on SCF data using \code{svyglm()} across the SCF's
five implicates.  Returns coefficient estimates, standard errors, test
statistics, and model diagnostics.
}
\details{
Fits a replicate-weighted linear regression model to each implicate of
multiply-imputed SCF data and pools coefficients and standard errors using
Rubin’s Rules.
}
\section{Implementation}{

Ordinary least squares (OLS) regression estimates the linear relationship
between a continuous outcome and one or more predictor variables. Each
coefficient represents the expected change in the outcome for a one-unit
increase in the corresponding predictor, holding all other predictors
constant.

Use this function to model associations between SCF variables while
accounting for complex survey design and multiple imputation.

This function takes a \code{scf_mi_survey} object and a model formula. Internally,
it fits a weighted linear regression to each implicate using
\code{survey::svyglm()}, extracts coefficients and variance-covariance matrices,
and pools them via \code{\link[=scf_MIcombine]{scf_MIcombine()}}.
}

\examples{
# Do not implement these lines in real analysis:
# Use functions `scf_download()` and `scf_load()`
td <- tempfile("ols_")
dir.create(td)

src <- system.file("extdata", "scf2022_mock_raw.rds", package = "scf")
file.copy(src, file.path(td, "scf2022.rds"), overwrite = TRUE)
scf2022 <- scf_load(2022, data_directory = td)

# Example for real analysis: Run OLS model
model <- scf_ols(scf2022, networth ~ income + age)
summary(model)

# Do not implement these lines in real analysis: Cleanup for package check
unlink(td, recursive = TRUE, force = TRUE)

}
\seealso{
\code{\link[=scf_glm]{scf_glm()}}, \code{\link[=scf_logit]{scf_logit()}}, \code{\link[=scf_MIcombine]{scf_MIcombine()}}
}
