% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_lagged.R
\name{plot.cross_lagged}
\alias{plot.cross_lagged}
\title{Plot Cross-Lagged Correlation Results}
\usage{
\method{plot}{cross_lagged}(x, ...)
}
\arguments{
\item{x}{An object of class "cross_lagged" containing the results of a cross-lagged
correlation analysis performed by cross_lagged().}

\item{...}{Additional parameters (currently ignored).}
}
\value{
A \code{ggplot} object representing the cross-lagged correlation analysis
results. This plot includes bars for ACF values at different lags
and dashed lines for the upper and lower confidence intervals.
}
\description{
Plots the cross-lagged correlation results calculated by cross_lagged().
This method generates a bar plot showing the autocorrelation function (ACF) values
for different lags, along with dashed lines indicating the upper and lower confidence
intervals. The plot is created using \code{ggplot2}.
}
\examples{
#Creating a sample dataset
reversal_withdrawal <- data.frame(
  phase = c(rep("baseline1", 6), rep("teratment1", 5), rep("baseline2", 5), rep("teratment2", 5)),
  time = 1:21,
  extbehavs = c(15, 10, 14, 17, 13, 12, 2, 1, 1, 0, 0, 9, 9, 11, 15, 20, 1, 0, 4, 0, 1)
)

reversal_withdrawal$synth <- sapply(reversal_withdrawal$time, function(x) {
  stats::rpois(1, x)
})

reversal_withdrawal <- as.data.frame(reversal_withdrawal)

# Using the cross_lagged function
cl_result <- cross_lagged(reversal_withdrawal, .x = "time", .y = "synth")

# Plot the cross-lagged correlation results
plot(cl_result)

}
