% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_BCSMD.R
\name{default_times}
\alias{default_times}
\title{Calculate default initial treatment time and follow-up time.}
\usage{
default_times(
  design,
  case,
  phase,
  session,
  cluster = NULL,
  series = NULL,
  treatment_name = NULL,
  data = NULL
)
}
\arguments{
\item{design}{Character string to specify whether data comes from a treatment
reversal (\code{"TR"}), multiple baseline across participants
(\code{"MBP"}), replicated multiple baseline across behaviors
(\code{"RMBB"}), or clustered multiple baseline across participants
(\code{"CMB"}).}

\item{case}{vector of case indicators or name of a character or factor vector
within \code{data} indicating unique cases.}

\item{phase}{vector of treatment indicators or name of a character or factor
vector within \code{data} indicating unique treatment phases.}

\item{session}{vector of measurement occasions or name of numeric vector
within \code{data} of measurement times.}

\item{cluster}{(Optional) vector of cluster indicators or name of a character
or factor vector within \code{data} indicating clusters.}

\item{series}{(Optional) vector of series indicators or name of a character
or factor vector within \code{data} indicating series.}

\item{treatment_name}{(Optional) character string corresponding to the name
of the treatment phase.}

\item{data}{(Optional) dataset to use for analysis. Must be a
\code{data.frame}.}
}
\value{
A list of time range, default initial treatment time, and default
  follow-up time.
}
\description{
Calculate the default initial treatment time and follow-up time
  that are used to define and estimate the between-case standardized mean
  differences for multiple baseline designs and variations.
}
\note{
If treatment_name is left null, it will choose the second level of the
  phase variable to be the treatment phase.
}
\examples{
data(Laski)
default_times(design = "MBP", 
              case = case, phase = treatment, session = time, 
              data = Laski)

data(Thiemann2001)
default_times(design = "RMBB", 
              case = case, series = series, 
              phase = treatment, session = time, 
              data = Thiemann2001)

data(Bryant2018)
default_times(design = "CMB", 
              cluster = group, case = case, 
              phase = treatment, session = session, 
              data = Bryant2018)
              
}
