#include "scalablebayesm.h"
#include <RcppArmadillo.h>

using namespace Rcpp;
using namespace arma;

//[[Rcpp::export]]

List drawMixture_rcpp_loop(List const& predcompdraws, arma::mat const& preddeltadraws, 
                                     arma::mat const& Z, bool drawdelta, arma::mat olddelta, 
                                     arma::vec const& deltabar, arma::mat const& Ad, 
                                     arma::mat const& mubar, arma::mat const& Amu, int nu, 
                                     arma::mat const& V, arma::vec const& a, arma::vec oldprob, arma::vec ind,
                                     int const& R, int const& keep, int const& nprint, int const& N, bool verbose) {
  // Wayne Taylor 9/10/2014
  
  int mkeep = 0;    
  
  mat probdraw(floor(R/keep),oldprob.size());
  List compdraw(floor(R/keep));
  mat betabar;
  
  List compdrawList = predcompdraws[0]; // first element of predcompdraws list
  List compdrawList0 = compdrawList[0]; // first element of list of 1
  vec mu = compdrawList0[0]; // first element of list of 2 (mu and rooti)
  List nmix;
  
  //int N = Z.n_rows;
  int nz = Z.n_cols;
  
  
  
  int nvar = mu.size();
  mat oldbetas(N, nvar), root;
  mat Deltadraw(1,1); if(drawdelta) Deltadraw.zeros(floor(R/keep), nz*nvar);//enlarge Deltadraw only if the space is required
  
  ivec r = randi(N, distr_param(0, predcompdraws.size()-1));
  
  for(int lgt = 0; lgt<N; lgt++) {
    compdrawList = predcompdraws[r[lgt]];
    compdrawList0 = compdrawList[0];
    vec mu = compdrawList0[0];
    mat rooti = as<mat>(compdrawList0[1]);
    
    if(drawdelta) olddelta = preddeltadraws.row(r[lgt]);
    
    //note: beta_i = Delta*z_i + u_i  Delta is nvar x nz
    if(drawdelta){
      olddelta.reshape(nvar,nz);
      //betabar = mu+olddelta*vectorise(Z(lgt),span::all); //
      betabar = mu + olddelta * Z.row(lgt).t(); 
    } else {
      betabar = mu;
    }
    
    root = solve(trimatu(rooti), eye(nvar,nvar));
    oldbetas(lgt,span::all) = trans(betabar + trans(root) * as<vec>(rnorm(nvar)));
  }
  
  if((nprint>0) & verbose) startMcmcTimer();
  
  // start main iteration loop
  for(int rep = 0; rep<R; rep++) {
    
    //first draw comps,ind,p | {beta_i}, delta
    // ind,p need initialization comps is drawn first in sub-Gibbs
    List mgout;
    
    if(drawdelta) {
      olddelta.reshape(nvar,nz);
      mgout = rmixGibbs1(oldbetas-Z*trans(olddelta),mubar,Amu,nu,V,a,oldprob,ind);
    } else {
      mgout = rmixGibbs1(oldbetas,mubar,Amu,nu,V,a,oldprob,ind);
    }
    
    List oldcomp = mgout["comps"];
    oldprob = as<vec>(mgout["p"]); //conversion from Rcpp to Armadillo requires explict declaration of variable type using as<>
    ind = as<vec>(mgout["z"]); //conversion from Rcpp to Armadillo requires explict declaration of variable type using as<>
    
    //now draw delta | {beta_i}, ind, comps
    if(drawdelta) {
      olddelta = drawDelta1(Z,oldbetas,ind,oldcomp,deltabar,Ad);
    }
    
    // print time to completion and draw # every nprint'th draw
    if ((nprint>0) & verbose) if ((rep+1)%nprint==0) infoMcmcTimer(rep, R);
    
    if((rep+1)%keep==0){
      mkeep = (rep+1)/keep;
      probdraw(mkeep-1,span::all) = trans(oldprob);
      //zdraw(mkeep-1,span::all) = trans(ind);
      compdraw[mkeep-1] = oldcomp;
      if(drawdelta) Deltadraw(mkeep-1, span::all) = trans(vectorise(olddelta));
    }
  }
  if((nprint>0) & verbose) endMcmcTimer();
  
  //return List::create(
  //  Named("probdraw") = probdraw, 
  //  Named("zdraw")    = R_NilValue, 
  //  Named("compdraw") = compdraw,
  //  Named("Deltadraw") = Deltadraw);
  
  nmix = List::create(Named("probdraw") = probdraw,
                      Named("zdraw") = R_NilValue, //sets the value to NULL in R
                      Named("compdraw") = compdraw);
  
   if(drawdelta){
     return(List::create(
         Named("Deltadraw") = Deltadraw,
         Named("nmix") = nmix));
   } else {
     return(List::create(
         Named("nmix") = nmix));
   }
}
