% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/santaR_auto_summary.R
\name{santaR_auto_summary}
\alias{santaR_auto_summary}
\title{Summarise, report and save the results of a santaR analysis}
\usage{
santaR_auto_summary(
  SANTAObjList,
  targetFolder = NA,
  summaryCSV = TRUE,
  CSVName = "summary",
  savePlot = TRUE,
  plotCutOff = 0.05,
  showTotalMeanCurve = TRUE,
  showConfBand = TRUE,
  legend = TRUE,
  fdrBH = TRUE,
  fdrBY = FALSE,
  fdrBonf = FALSE,
  CIpval = TRUE,
  plotAll = FALSE
)
}
\arguments{
\item{SANTAObjList}{A list of \emph{SANTAObj} with \emph{p}-values calculated, as generated by \code{\link{santaR_auto_fit}}.}

\item{targetFolder}{(NA or str) NA or the path to a folder in which to save summary.xls and plots. If NA no outputs are saved to disk. If \code{targetFolder} does not exist, folders will be created. Default is NA.}

\item{summaryCSV}{If TRUE save the (\emph{corrected if applicable}) \emph{p}-values to \code{'CSVName'_summary.csv}, \code{'CSVName'_pvalue-all.csv}, \code{'CSVName'_pvalue-dist.csv}, \code{'CSVName'_pvalue-dist.csv} (\emph{default \code{summary_summary.csv},...}). Default is TRUE.}

\item{CSVName}{(string) Filename of the \emph{csv} to save. Default is \code{'summary'}.}

\item{savePlot}{If TRUE save to \code{targetFolder} all variables with \emph{p} < \code{plotCutOff} ordered by \emph{p}-values. Default is TRUE.}

\item{plotCutOff}{(float) \emph{P}-value cut-off value to save summary plots to disk. Default 0.05.}

\item{showTotalMeanCurve}{If TRUE add the mean curve across all groups on the plots. Default is TRUE.}

\item{showConfBand}{If TRUE plot the confidence band for each group. Default is TRUE.}

\item{legend}{If TRUE add a legend to the plots. Default is TRUE.}

\item{fdrBH}{If TRUE add the Benjamini-Hochberg corrected \emph{p}-value to the output. Default is TRUE.}

\item{fdrBY}{If TRUE add the Benjamini-Yekutieli corrected \emph{p}-value to the output. Default is FALSE.}

\item{fdrBonf}{If TRUE add the Bonferroni corrected \emph{p}-value to the output. Default is FALSE.}

\item{CIpval}{If TRUE add the upper and lower confidence interval on \emph{p}-value to the output. Default is TRUE.}

\item{plotAll}{If TRUE override the \code{plotCutOff} parameter and plot all variables. Default is FALSE.}
}
\value{
A list: \code{result$pval.all} \code{data.frame} of \emph{p}-values, with all variables as rows and different \emph{p}-value corrections as columns. \code{result$pval.summary} \code{data.frame} of number of variables with a \emph{p}-value inferior to a cut-off. Different metric and \emph{p}-value correction as rows, different cut-off (\emph{Inf 0.05}, \emph{Inf 0.01}, \emph{Inf 0.001}) as columns.
}
\description{
After multiple variables have been analysed using \code{\link{santaR_auto_fit}}, \code{santaR_auto_summary} helps identify significant results and summarise them in an interpretable fashion. Correction for multiple testing can be applied to generate Bonferroni \cite{[1]}, Benjamini-Hochberg \cite{[2]} or Benjamini-Yekutieli \cite{[3]} corrected \emph{p}-values. \emph{P}-values can be saved to disk in \code{.csv} files. For a given significance cut-off (\code{plotCutOff}), the number of variables significantly altered is reported and plots are automatically saved to disk by increasing \emph{p}-value. The aspect of the plots can be altered such as the representation of confidence bands (\code{showConfBand}) or the generation of a mean curve across all samples (\code{showTotalMeanCurve}) to help assess difference between groups when group sizes are unbalanced.
}
\examples{
## 2 variables, 56 measurements, 8 subjects, 7 unique time-points
## Default parameter values decreased to ensure an execution < 2 seconds
inputData     <- acuteInflammation$data[,1:2]
ind           <- acuteInflammation$meta$ind
time          <- acuteInflammation$meta$time
group         <- acuteInflammation$meta$group
SANTAObjList  <- santaR_auto_fit(inputData, ind, time, group, df=5, ncores=0, CBand=TRUE,
                                pval.dist=TRUE, nBoot=100, nPerm=100)
# Input data generated: 0.02 secs
# Spline fitted: 0.03 secs
# ConfBands done: 0.53 secs
# p-val dist done: 0.79 secs
# total time: 1.37 secs
result <- santaR_auto_summary(SANTAObjList)
print(result)
# $pval.all
#              dist dist_upper  dist_lower     curveCorr    dist_BH
# var_1 0.03960396 0.09783202 0.015439223 -0.2429725352 0.03960396
# var_2 0.00990099 0.05432519 0.001737742  0.0006572238 0.01980198
#
# $pval.summary
#       Test Inf 0.05 Inf 0.01 Inf 0.001
# 1    dist        2        1         0
# 2 dist_BH        2        0         0

}
\references{
[1] Bland, J. M. & Altman, D. G. \emph{Multiple significance tests: the Bonferroni method}. British Medial Journal \strong{310}, 170 (1995).

[2] Benjamini, Y. & Hochberg, Y. \emph{Controlling the False Discovery Rate: A Practical and Powerful Approach to Multiple Testing}. Journal of the Royal Statistical Society \strong{57}, 1, 289-300 (1995).

[3] Benjamini, Y. & Yekutieli, D. \emph{The control of the false discovery rate in multiple testing under depencency}. The Annals of Statistics \strong{29}, 1165-1188 (2001).
}
\seealso{
Other AutoProcess: 
\code{\link{santaR_auto_fit}()},
\code{\link{santaR_plot}()},
\code{\link{santaR_start_GUI}()}

Other Analysis: 
\code{\link{get_grouping}()},
\code{\link{get_ind_time_matrix}()},
\code{\link{santaR_CBand}()},
\code{\link{santaR_auto_fit}()},
\code{\link{santaR_fit}()},
\code{\link{santaR_plot}()},
\code{\link{santaR_pvalue_dist}()},
\code{\link{santaR_pvalue_fit}()},
\code{\link{santaR_start_GUI}()}
}
\concept{Analysis}
\concept{AutoProcess}
