% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.sampbias.R
\name{is.sampbias}
\alias{is.sampbias}
\title{Is Method for Class sampbias}
\usage{
\method{is}{sampbias}(object, class2 = "sampbias")
}
\arguments{
\item{object}{an object of the class \code{sampbias}}

\item{class2}{the names of the class to which is relations are to be
examined defined, or (more efficiently) the class definition objects for the
classes.}
}
\value{
The function returns a logical indicating whether the object is a
  is of the class \code{sampbias}.
}
\description{
Check class of \code{sampbias} objects.
}
\details{
With two arguments, tests whether object can be treated as from class2.
With one argument, returns all the super-classes of this object's class.
}
\examples{
\donttest{
  #simulate data
  occ <- data.frame(species = rep(sample(x = LETTERS, size = 5), times = 10),
                   decimalLongitude = runif(n = 50, min = 12, max = 20),
                   decimalLatitude = runif(n = 50, min = -4, max = 4))

  out <- calculate_bias(x = occ, terrestrial = TRUE)
  is(out)
}
}
\keyword{methods}
