% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optiWrap.r
\name{optiWrap}
\alias{optiWrap}
\title{Wrapper for optimisation with automatically computed gradient}
\usage{
optiWrap(
  par,
  fn,
  ...,
  method = c("BFGS", "L-BFGS-B", "CG"),
  lower = -Inf,
  upper = Inf,
  control = list(),
  hessian = FALSE,
  trace = FALSE
)
}
\arguments{
\item{par}{Initial value}

\item{fn}{Function to be minimized}

\item{...}{Further argument to be passed to 'fn'}

\item{method}{Optimization method}

\item{lower, upper}{Bounds on the variables for 'L-BFGS-B'}

\item{control}{A list of control parameters passed to `optim`}

\item{hessian}{If 'TRUE' a *numerically* differentiated matrix is returned.}

\item{trace}{If 'TRUE', keep trace of the visited points}
}
\description{
Wrapper for calling \code{stats::optim} with a gradient
computed by automatic differentiation
}
\details{
The gradient of \code{fn} is computed using \code{unlist(d(fn(x)))}. It is
computed at the same time as \code{fn(x)}` and stored for when \code{optim} calls
the gradient. In most cases this should be more efficient than defining 
\code{gr = \(x) unlist(d(f(dual(x))))}.

Parameters 'method' 'lower' 'upper' 'control' and 'hessian' are passed directly to 
\code{optim}.
}
\examples{
f <- function(x) (x[1] - x[2])**4 + (x[1] + 2*x[2])**2 + x[1] + x[2]

X <- seq(-1, 0.5, by = 0.01)
Y <- seq(-1, 0.5, by = 0.01)
Z <- matrix(NA_real_, nrow = length(X), ncol = length(Y))
for(i in seq_along(X)) for(j in seq_along(Y)) Z[i,j] <- f(c(X[i],Y[j]))

contour(X,Y,Z, levels = c(-0.2, 0, 0.3, 2**(0:6)), main = "BFGS")
opt <- optiWrap(c(0,0), f, method = "BFGS", trace = TRUE)
lines(t(opt$trace), type = "o", col = "red")

}
\seealso{
\code{\link[stats]{optim}}
}
