% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zTest.R
\name{safeZTest}
\alias{safeZTest}
\alias{safe.z.test}
\title{Safe Z-Test}
\usage{
safeZTest(
  x,
  y = NULL,
  paired = FALSE,
  designObj = NULL,
  pilot = FALSE,
  ciValue = NULL,
  tol = 1e-05,
  na.rm = FALSE,
  ...
)

safe.z.test(
  x,
  y = NULL,
  paired = FALSE,
  designObj = NULL,
  pilot = FALSE,
  tol = 1e-05,
  ...
)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{y}{an optional (non-empty) numeric vector of data values.}

\item{paired}{a logical indicating whether you want the paired z-test.}

\item{designObj}{an object obtained from \code{\link{designSafeZ}()}, or \code{NULL}, when pilot is set to \code{TRUE}.}

\item{pilot}{a logical indicating whether a pilot study is run. If \code{TRUE}, it is assumed that the number of
samples is exactly as planned. The default null h0=1 is used, alpha=0.05, and alternative="twoSided" is used.
To change these default values, please use \code{\link{designSafeZ}()}.}

\item{ciValue}{numeric is the ciValue-level of the confidence sequence. Default ciValue=NULL, and ciValue = 1 - alpha}

\item{tol}{numeric > 0, only used if pilot equals \code{TRUE}, as it then specifies the mesh used to find the test
defining parameter to construct a pilot design object.}

\item{na.rm}{a logical value indicating whether \code{NA} values should be stripped before
the computation proceeds.}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
Returns an object of class 'safeTest'. An object of class 'safeTest' is a list containing at least the
following components:

\describe{
  \item{statistic}{the value of the test statistic. Here the z-statistic.}
  \item{n}{The realised sample size(s).}
  \item{eValue}{the e-value of the safe test.}
  \item{confInt}{To be implemented: a safe confidence interval for the mean appropriate to the specific alternative
  hypothesis.}
  \item{estimate}{the estimated mean or difference in means or mean difference depending on whether it was a one-
  sample test or a two-sample test.}
  \item{h0}{the specified hypothesised value of the mean or mean difference depending on whether it was a one-sample
  or a two-sample test.}
  \item{testType}{any of "oneSample", "paired", "twoSample" effectively provided by the user.}
  \item{dataName}{a character string giving the name(s) of the data.}
  \item{designObj}{an object of class "safeDesign" described in \code{\link{designSafeZ}()}.}
  \item{call}{the expression with which this function is called.}
}
}
\description{
Safe one and two sample z-tests on vectors of data. The function is modelled after \code{\link[stats]{t.test}()}.
}
\examples{

designObj <- designSafeZ(meanDiffMin=0.6, alpha=0.008,
                         alternative="greater", testType="twoSample",
                         ratio=1.2)

set.seed(1)
x <- rnorm(100)
y <- rnorm(100)
safeZTest(x, y, designObj=designObj)      #

safeZTest(1:10, y = c(7:20), pilot=TRUE, alternative="less")      # s = 7.7543e+20 > 1/alpha
}
