% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tTest.R
\name{designPilotSafeT}
\alias{designPilotSafeT}
\title{Designs a Safe T-Test Based on Planned Samples nPlan}
\usage{
designPilotSafeT(
  nPlan = 50,
  alpha = 0.05,
  alternative = c("twoSided", "greater", "less"),
  h0 = 0,
  lowParam = 0.01,
  highParam = 1.2,
  tol = 0.01,
  inverseMethod = TRUE,
  logging = FALSE,
  paired = FALSE,
  maxIter = 10
)
}
\arguments{
\item{nPlan}{the planned sample size(s).}

\item{alpha}{numeric in (0, 1) that specifies the tolerable type I error control --independent of n-- that the
designed test has to adhere to. Note that it also defines the rejection rule e10 > 1/alpha.}

\item{alternative}{a character string specifying the alternative hypothesis must be one of "twoSided" (default),
"greater" or "less".}

\item{h0}{a number indicating the hypothesised true value of the mean under the null. For the moment h0=0.}

\item{lowParam}{numeric defining the smallest delta of the search space for the test-defining deltaS
for scenario 3. Currently not yet in use.}

\item{highParam}{numeric defining the largest delta of the search space for the test-defining deltaS
for scenario 3. Currently not yet in use.}

\item{tol}{a number that defines the stepsizes between the lowParam and highParam.}

\item{inverseMethod}{logical, always \code{TRUE} for the moment.}

\item{logging}{logical, if \code{TRUE}, then add invSToTThresh to output.}

\item{paired}{logical, if \code{TRUE} then paired t-test.}

\item{maxIter}{numeric > 0, the maximum number of iterations of adjustment to the candidate set from
lowParam to highParam, if the minimum is not found.}
}
\value{
Returns an object of class 'safeDesign'. An object of class 'safeDesign' is a list containing at least the
following components:

\describe{
  \item{nPlan}{the planned sample size(s).}
  \item{parameter}{the safe test defining parameter. Here deltaS.}
  \item{esMin}{the minimal clinically relevant standardised effect size provided by the user.}
  \item{alpha}{the tolerable type I error provided by the user.}
  \item{beta}{the tolerable type II error provided by the user.}
  \item{alternative}{any of "twoSided", "greater", "less" provided by the user.}
  \item{testType}{any of "oneSample", "paired", "twoSample" provided by the user.}
  \item{paired}{logical, \code{TRUE} if "paired", \code{FALSE} otherwise.}
  \item{h0}{the specified hypothesised value of the mean or mean difference depending on
  whether it was a one-sample or a two-sample test.}
  \item{ratio}{default is 1. Different from 1, whenever testType equals "twoSample", then it defines
  ratio between the planned randomisation of condition 2 over condition 1.}
  \item{lowN}{the smallest n of the search space for n provided by the user.}
  \item{highN}{the largest n of the search space for n provided by the user.}
  \item{lowParam}{the smallest delta of the search space for delta provided by the user.}
  \item{highParam}{the largest delta of the search space for delta provided by the user.}
  \item{tol}{the step size between lowParam and highParam provided by the user.}
  \item{pilot}{\code{FALSE} (default) specified by the user to indicate that the design is not a pilot study.}
  \item{call}{the expression with which this function is called.}
}
}
\description{
Designs a safe experiment for a prespecified tolerable type I error based on planned sample
size(s), which are fixed ahead of time. Outputs a list that includes the deltaS, i.e., the
safe test defining parameter.
}
\examples{
designPilotSafeT(nPlan=30)
}
