% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataVill.R
\docType{data}
\name{dataVill}
\alias{dataVill}
\title{Sample Data for Small Area Estimation using Averaging Pseudo Area Level Model}
\format{
A data frame with 83 observations on the following 8 variables:
\describe{
  \item{Area1}{Province}
  \item{Area2}{Region}
  \item{Area3}{Sub-district}
  \item{Area4}{Village}
  \item{ydir_area4}{Direct Estimation of y}
  \item{vardir_area4}{Sampling variance of y}
  \item{X1}{Auxiliary variable}
  \item{N}{Number of population in area4}
}
}
\usage{
dataVill
}
\description{
Dataset to simulate Small Area Estimation using Averaging Pseudo Area Level Model
This data is generated by these following steps:
\enumerate{
\item Generate population data consisting Area1 (province), Area2 (region), Area3 (sub-district), Area4 (village), and Unit. The auxiliary variabels are generated by Uniform distribution with \eqn{(x1 ~ U(40, 100))} and Normal distribution with \eqn{(x2 ~ N(70, 5))}. The coefficient parameters are set as \eqn{\beta_{0} = 0.5}, \eqn{\beta_{1} = 0.2}, and \eqn{\beta_{2} = 0.2}
\item Calculate \eqn{y_{k} = \beta_{0}+\beta_{1}*x1_{k}+\beta_{2}*x_2{k}}
\item Generate number of sample with simple random sampling with replacement
\item Calculate \eqn{ydir_area4 = \frac{\Sigma{y_{k}}}{n}}, \eqn{vardir_area4 = \frac{\Sigma{(y_{k}-\frac{\Sigma{y_{k}}}{n})^2}}{n-1}}, and auxiliary variable \eqn{X1 = \frac{\Sigma{x1_{k}}}{n}}
\item Calculate N (number of population) based on the initial population generated for each Area4 selected as a sample
\item Area1, Area2, Area3, Area4, ydir_area4, vardir_area4, X1, and N are combined in a dataframe called dataVill.
}
}
\keyword{datasets}
