% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adf_lag_select.R
\name{adf_lag_select}
\alias{adf_lag_select}
\title{Identify Optimal Lag Order Selection for (Augmented) Dickey-Fuller Tests}
\usage{
adf_lag_select(x, min_lag = 0, max_lag = NULL)
}
\arguments{
\item{x}{a vector}

\item{min_lag}{the minimum lag order to use. Defaults to 0.}

\item{max_lag}{the maximum lag order to use. Defaults to Schwert's (1989) upper lag.}
}
\value{
\code{adf_lag_select()} returns a list of length 3. The first element
in the list is a data frame of a series of (Augmented) Dickey-Fuller tests
for no-drift, no-trend. The second is a data frame of a series of (Augmented)
Dickey-Fuller tests for drift, no trend. The third is a data frame of a series
of (Augmented) Dickey-Fuller tests for a drift and trend. Each data frame has
the following columns communicating the following information.
\enumerate{
\item The lag order
\item The (A)DF statistic for the lag order.
\item The Akaike information criterion for the model.
\item Schwartz' (Bayesian) criteron for the model.
\item The absolute value of the last lagged first difference in the model.
\item The "modified" Akaike information criterion for the model.
\item The "modified" Schwarz' (Bayesian) criterion for the model.
\item A note indicating if the lag was suggested by Schwert (1989) or Said and Dickey (1984)
}
}
\description{
\code{adf_lag_select()} runs a series of (Augmented) Dickey-Fuller
tests and returns information that may (or may not) be useful in identify
a potential lag order for unit root tests.
}
\details{
This function removes missing values from the vector before calculating test
statistics.

The lower bound lag order suggested by Schwert (1989) and the default suggested
by Said and Dickey (1984) do not meaningfully separate from each other until
the length of the series reaches 127. Under those conditions, if the \code{note}
column returned by this function for a finite series does not identify the
Said and Dickey (1984) default, but identifies the Schwert (1989) lower
bound, interpret the latter as the former.
}
\examples{

x <- head(tbills$tb3m, 500)
adf_lag_select(x)

}
\author{
Steven V. Miller
}
