% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{load_events_log}
\alias{load_events_log}
\title{Load cleaned events log data from the volleydata repository.}
\usage{
load_events_log(league = NULL, seasons = NULL)
}
\arguments{
\item{league}{A string specifying which of "mlv", "lovb", or "au" to load data for.}

\item{seasons}{An integer or vector of integers of seasons to fetch data for. Defaults to all available seasons.}
}
\value{
A data frame containing the events log data for the specified seasons.\tabular{ll}{
   Column Name \tab Type \cr
   match_id \tab int \cr
   season \tab int \cr
   match_datetime \tab chr \cr
   set \tab int \cr
   set_start_time \tab chr \cr
   set_end_time \tab chr \cr
   set_duration \tab int \cr
   set_final_home_score \tab int \cr
   set_final_away_score \tab int \cr
   event_type \tab chr \cr
   event_time \tab chr \cr
   libero_enters \tab lgl \cr
   team_involved \tab chr \cr
   libero_jersey_number \tab int \cr
   libero_substitute_jersey_number \tab int \cr
   rally_start_time \tab chr \cr
   rally_end_time \tab chr \cr
   rally_point_winner \tab chr \cr
   substitute_in_jersey_number \tab int \cr
   substitute_out_jersey_number \tab int \cr
   challenge_approved \tab chr \cr
   challenge_reason \tab chr \cr
   challenge_method \tab chr \cr
   challenge_response \tab chr \cr
   challenge_at_home_score \tab dbl \cr
   challenge_at_away_score \tab dbl \cr
   challenge_score_change \tab chr \cr
   serving_team \tab chr \cr
   current_home_score \tab dbl \cr
   current_away_score \tab dbl \cr
   home_team_p1 \tab dbl \cr
   home_team_p2 \tab dbl \cr
   home_team_p3 \tab dbl \cr
   home_team_p4 \tab dbl \cr
   home_team_p5 \tab dbl \cr
   home_team_p6 \tab dbl \cr
   away_team_p1 \tab dbl \cr
   away_team_p2 \tab dbl \cr
   away_team_p3 \tab dbl \cr
   away_team_p4 \tab dbl \cr
   away_team_p5 \tab dbl \cr
   away_team_p6 \tab dbl \cr
   verified_time \tab chr \cr
   verified_method \tab chr \cr
   sanction_type \tab chr \cr
   sanction_remark \tab dbl \cr
   sanction_staff_role \tab chr \cr
   staff_first_name \tab chr \cr
   staff_last_name \tab chr \cr
   staff_type \tab chr \cr
   is_exceptional \tab chr \cr
   league \tab chr \cr
}
}
\description{
Load cleaned events log data from the volleydata repository.
}
\examples{
\donttest{try({load_events_log("mlv", 2024)})}
}
