#' Latest R release with a Windows installer available for download
#'
#' [r_release()] works based on the SVN tags in the main R source code
#' repository. However, an SVN tag does not mean that the same version
#' is available for download. `r_release_win` returns the latest
#' version for which a Windows installer is available.
#'
#' @section Note:
#' This function is superseded by [resolve()]:
#' ```{r}
#' r_release_win()
#' ```
#' ```{r}
#' resolve("release", platform = "windows")
#' ```
#'
#' @return A one row data frame, with columns \sQuote{version},
#'   \sQuote{date}, \sQuote{URL} and \sQuote{nickname}.
#'
#' @family R downloads
#' @export
#' @examplesIf rversions:::is_online()
#' r_release()
#' r_release_win()

r_release_win <- function() {
  df <- api_version_df1("r-release-win")
  df
}
