% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midas_functions.R
\name{MEM_X_loglik_no_skew}
\alias{MEM_X_loglik_no_skew}
\title{MEM-X log-likelihood (no skewness parameter)}
\usage{
MEM_X_loglik_no_skew(param, x, z)
}
\arguments{
\item{param}{Vector of starting values.}

\item{x}{Dependent variable, usually the realized volatility. It must be positive and "xts" object.}

\item{z}{Additional daily variable which must be an "xts" object, and with the same length of x.}
}
\value{
The resulting vector is the log-likelihood value for each \eqn{i,t}.
}
\description{
Obtains the log-likelihood of the base MEM, with an additional X part (for instance, the VIX).
}
\examples{
\donttest{
start_val<-c(alpha=0.10,beta=0.8,delta=0.01)
real<-(rv5['2009/2010'])^0.5		# realized volatility
z<-vix['2009/2010']
sum(MEM_X_loglik_no_skew(start_val,real,z))
}
}
\references{
\insertAllCited{}
}
\keyword{internal}
