% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Means_DDCt.R
\name{Means_DDCt}
\alias{Means_DDCt}
\title{Delta Delta Ct pairwise comparisons using a fitted model}
\usage{
Means_DDCt(model, specs, p.adj = "none")
}
\arguments{
\item{model}{A fitted model object (typically an \code{lmer} or \code{lm} object)
created by \code{ANOVA_DCt()}, \code{ANOVA_DDCt()} or \code{REPEATED_DDCt()}.}

\item{specs}{A character string or character vector specifying the predictors or
combinations of predictors over which relative expression values are desired.
This argument follows the specification syntax used by
\code{emmeans::emmeans()} (e.g., \code{"Factor"},
\code{"Factor1 | Factor2"}).}

\item{p.adj}{Character string specifying the method for adjusting p-values.
See \code{\link[stats]{p.adjust}} for available options.}
}
\value{
A data frame containing estimated relative expression values, confidence
intervals, p-values, and significance levels derived from the fitted
model.
}
\description{
Performs relative expression (fold change) analysis based on the
Delta Delta Ct (ddCt) methods using a fitted model object produced by
\code{ANOVA_DCt()}, \code{ANOVA_DDCt()} or \code{REPEATED_DDCt()}.
}
\details{
The \code{Means_DDCt} function performs pairwise comparisons of relative expression values fo all combinations using
estimated marginal means derived from a fitted model.
For ANOVA models, relative expression values can be obtained for main effects,
interactions, and sliced (simple) effects.
For ANCOVA models returned by the \pkg{rtpcr} package, only simple
effects are supported.

Internally, this function relies on the \pkg{emmeans} package to
compute marginal means and contrasts, which are then back-transformed
to fold change values using the ddCt framework.
}
\examples{

data <- read.csv(system.file("extdata", "data_3factor.csv", package = "rtpcr"))

# Obtain a fitted model from ANOVA_DDCt
res <- ANOVA_DDCt(
  data,
  numOfFactors = 3,
  numberOfrefGenes = 1,
  mainFactor.column = 1,
  block = NULL)

# Relative expression values for Type main effect
lm <- res$perGene$PO$lm
Means_DDCt(lm, specs = "Type")

# Relative expression values for Concentration main effect
Means_DDCt(lm, specs = "Conc")

# Relative expression values for Concentration sliced by Type
Means_DDCt(lm, specs = "Conc | Type")

# Relative expression values for Concentration sliced by Type and SA
Means_DDCt(lm, specs = "Conc | Type * SA")

}
\author{
Ghader Mirzaghaderi
}
