% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encode.R
\name{sixelEncode}
\alias{sixelEncode}
\title{Create SIXEL escape sequence from image data}
\usage{
sixelEncode(image, max.colors = 256, iter.max = 10)
}
\arguments{
\item{image}{a three dimensional RGB array with values ranging from 0 to 1.}

\item{max.colors}{integer, max colors of the palette. The maximum is 256.
Default is 256.}

\item{iter.max}{integer, maximum number of iterations for k-means clustering.}
}
\value{
SIXEL escape sequence
}
\description{
Create SIXEL escape sequence from image data. Quantization is done
by k-means clustering.
}
\examples{
img <- png::readPNG(system.file("img", "Rlogo.png", package="png"))
cat(sixelEncode(img, 4))

}
