% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtx-utils.R
\name{mtrace}
\alias{mtrace}
\title{The trace of a square numeric matrix}
\usage{
mtrace(A)
}
\arguments{
\item{A}{A square numeric matrix.}
}
\value{
the sum of the values on the diagonal of the matrix \code{A}, i.e. \code{sum(diag(A))}.
}
\description{
Computes the trace of a square numeric matrix. If \code{A} is not numeric and square matrix,
 the function terminates with an error message.
}
\examples{
(a <- matrix(c(5,2,3, 4,-3,7, 4,1,2), ncol=3))
(b <- matrix(c(1,0,1, 0,1,2, 1,0,3), ncol=3))

mtrace(a)
mtrace(b)

## tr(A+B)=tr(A)+tr(B)
all.equal(mtrace(a) + mtrace(b), mtrace(a+b))

## tr(A)=tr(A')
all.equal(mtrace(a), mtrace(t(a)))

## tr(alphA)=alphatr(A)
alpha <- 0.5
all.equal(mtrace(alpha*a), alpha*mtrace(a))

##  tr(AB)=tr(BA)
all.equal(mtrace(a \%*\% b), mtrace(b \%*\% a))


##  tr(A)=tr(BAB-1)
all.equal(mtrace(a), mtrace(b \%*\% a \%*\% solve(b)))
}
\author{
Valentin Todorov, \email{valentin.todorov@chello.at}
}
