% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp_gen.R
\name{cp_gen}
\alias{cp_gen}
\title{Generate PARAFAC data sets, optionally with outliers}
\usage{
cp_gen(
  I = 20,
  J = 20,
  K = 20,
  nsim = 200,
  nf = 3,
  noise = 0.05,
  noise1 = 0,
  Acol = TRUE,
  Bcol = TRUE,
  Ccol = TRUE,
  congA = 0.5,
  congB = 0.5,
  congC = 0.5,
  eps = 0,
  type = c("none", "bl", "gl", "og"),
  c1 = 10,
  c2 = 0.1,
  silent = FALSE
)
}
\arguments{
\item{I}{number of observations}

\item{J}{number of variables}

\item{K}{number of occasions}

\item{nsim}{number of data sets to generate}

\item{nf}{number of PARAFAC components}

\item{noise}{level of homoscedastic (HO) noise}

\item{noise1}{level of heteroscedastic (HE) noise}

\item{Acol}{whether to apply collinearity with factor congA to mode A}

\item{Bcol}{whether to apply collinearity with factor congB to mode B}

\item{Ccol}{whether to apply collinearity with factor congC to mode C}

\item{congA}{collinearity factor for mode A}

\item{congB}{collinearity factor for mode B}

\item{congC}{collinearity factor for mode C}

\item{eps}{fraction of outliers (percent contamination)}

\item{type}{type of outliers: one of \code{"none"} for no outliers (possible only of \code{eps==0}), 
\code{"bl"} for bad leverage points, \code{"gl"} for good leverage points and
\code{"og"} for orthogonal outliers}

\item{c1}{parameter for outlier generation (\code{c1=10} for \code{type="bl"} 
or  \code{type="gl"} and \code{c1=1} for \code{type="og"})}

\item{c2}{parameter for outlier generation (\code{c2=0.1} for \code{type="bl"}
or \code{type="og"} and \code{c2=0} for \code{type="gl"})}

\item{silent}{whether to issue warnings}
}
\value{
A list consisting of the following lists:
 \itemize{
 \item As list of \code{nsim} matrices for the mode A
 \item Bs list of \code{nsim} matrices for the mode B
 \item Cs list of \code{nsim} matrices for the mode C
 \item Xs list of \code{nsim} PARAFAC data sets, each with dimension IxJxK
 \item Os list of \code{nsim} vectors containing the added outliers (if any)
 \item param list of parameters used for generation of the data sets
 }
}
\description{
Generates \code{nsim} data sets according to the given parameters.
 If \code{eps > 0}, the specified fraction of random outliers of the identified by the 
 parameter \code{type} type are added to the data sets.
}
\examples{
 ##  Generate one PARAFAC data set (nsim=1) with R=2 components (nf=2) and dimensions
 ##  50x10x10. Apply 0.15 homoscedastic noise and 0.10 heteroscedastic noise, apply 
 ##  collinearity with congruence factor 0.5 to all modes. Add 20\% bad leverage points.

 library(rrcov3way)
 xdat <- cp_gen(I=50, J=100, K=10, nsim=1, nf=2,
     noise=0.15, noise1=0.10, Acol=TRUE, Bcol=TRUE, Ccol=TRUE,
     congA=0.5, congB=0.5, congC=0.5,
     eps=0.2, type="bl")
 names(xdat)
   
}
\references{
Todorov, V. and Simonacci, V. and Gallo, M. and Trendafilov, N. (2023). A novel 
 estimation procedure for robust CANDECOMP/PARAFAC model fitting. 
 \emph{Econometrics and Statistics}. In press.

Tomasi, G. and Bro, R., (2006). A comparison of algorithms for fitting the PARAFAC model. 
 \emph{Computational Statistics & Data Analysis} \bold{50} (7), 1700--1734.

Faber, N.M. and Bro, R. and Hopke, P.K. (2003). Recent developments in CANDECOMP/PARAFAC algorithms: 
 A critical review. \emph{Chemometrics and Intelligent Laboratory Systems} \bold{65}, 119--137.
}
