% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMS.R, R/Opal.R
\docType{methods}
\name{upload2LMS}
\alias{upload2LMS}
\alias{upload2LMS,LMS-method}
\alias{upload2LMS,Opal-method}
\title{Upload content to LMS}
\usage{
upload2LMS(object, test, ...)

\S4method{upload2LMS}{LMS}(object, test, ...)

\S4method{upload2LMS}{Opal}(
  object,
  test,
  display_name = NULL,
  access = 4,
  overwrite = TRUE,
  open_in_browser = TRUE,
  as_survey = FALSE
)
}
\arguments{
\item{object}{An S4 object representing the LMS, such as an instance of the
\link{Opal} class.}

\item{test}{An \link{AssessmentTest}, \link{AssessmentTestOpal} or \link{AssessmentItem}
objects, or a character string with path to Rmd/md, zip or XML files.}

\item{...}{Additional arguments to be passed to the method, if applicable.}

\item{display_name}{A length one character vector to entitle resource in OPAL;
file name without extension or identifier of the object by default; optional.}

\item{access}{An integer value, optional; it is responsible for publication
status, where 1 - only those responsible for this learning resource; 2 -
responsible and other authors; 3 - all registered users; 4 - registered
users and guests. Default is 4.}

\item{overwrite}{A boolean value. If \code{TRUE}, and a file with the specified
display name already exists, it will be overwritten. Default is \code{TRUE}.}

\item{open_in_browser}{A boolean value; optional; it controls whether to open
a URL in default browser. Default is \code{TRUE.}}

\item{as_survey}{A boolean value, optional. If \code{TRUE}, the resource will be
treated as a survey; if \code{FALSE}, as a test. Default is \code{FALSE}.}
}
\description{
This is a generic function that handles the process of uploading content to
a Learning Management System (LMS). The content can be in the form of an
\code{AssessmentTest}, \code{AssessmentTestOpal}, \code{AssessmentItem} object, or a file in
Rmd, Markdown, zip or XML format.

This is a method that handles the process of uploading content to
a Learning Management System (LMS). The content can be in the form of an
\code{AssessmentTest}, \code{AssessmentTestOpal}, \code{AssessmentItem} object, or a file in
Rmd, Markdown, zip or XML format.

This is a generic function that handles the process of uploading content to
LMS Opal. The content can be in the form of an \code{AssessmentTest},
\code{AssessmentTestOpal}, \code{AssessmentItem} object, or a file in Rmd, Markdown,
zip or XML format.
}
