% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{boot.can}
\alias{boot.can}
\title{Bootstrap}
\usage{
boot.can(
  a,
  Rep = 200,
  method = "Andrews",
  msub = 0.9,
  seed,
  nsing = 5,
  prb = FALSE
)
}
\arguments{
\item{a}{output from rqcan \cr}

\item{Rep}{number of bootstrap replications (default=200) \cr}

\item{method}{"Andrews" (default) or ""xy" \cr}

\item{msub}{parameter defining the size of the bootstrap subsample for developmental work only: see the boot.can function \cr}

\item{seed}{a starting seed (default: missing: no new seed set) \cr}

\item{nsing}{number of consecutive singular replicatios to ignore (default = 5) \cr}

\item{prb}{if TRUE (default = FALSE), print every time 10 percent of the bootstrap samples are done \cr}
}
\value{
Returns list(As, Bs, sdc): As (Bs) are N by dim(alpha) (dim(beta)) arrays of all bootstrap alphs and beta values; sdc = sqrt(m/n): SD adjustment for m-choose-n bootstrap, or 1 for "xy" bootstrap
\cr
}
\description{
Internal function to carry out the bootstrap ; It is a sub-module of summary.rqcan; not intended for general use. \cr
The parameters may be passed by summary.rqcan (see below)
\cr
}
\details{
See help(summary.rqcan) ; If errors occur or modification is wanted, see the routine boot.can \cr
}
