% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store.R
\name{rdf_store}
\alias{rdf_store}
\title{Create an RDF Store}
\usage{
rdf_store(path = NULL)
}
\arguments{
\item{path}{Optional path for persistent storage. If NULL (default), creates
an in-memory store.}
}
\value{
An RDF store handle (integer)
}
\description{
Creates a new RDF store, either in-memory or backed by persistent storage.
}
\examples{
# In-memory store
store <- rdf_store()

# Persistent store (not supported on Windows)
\donttest{
if (.Platform$OS.type != "windows") {
  store <- rdf_store(file.path(tempdir(), "my_store"))
}
}
}
