% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classMethod_dynamics.r
\name{dynamics}
\alias{dynamics}
\title{Numerical Integration}
\arguments{
\item{times}{Times of interest (numeric vector).}

\item{fortran}{Switch between compiled Fortran and R code (logical). Default
is \code{FALSE} (was \code{TRUE} until package version 0.8.5).}

\item{proNames}{Assign names to output columns holding the process rates?
Default is \code{TRUE}.}

\item{...}{Auxiliary arguments passed to \code{\link[deSolve]{ode}}.
See notes below.}
}
\value{
The matrix returned by the integrator (see \code{\link[deSolve]{ode}}).
}
\description{
Compute a dynamic solution with the numerical algorithms from package
  \code{\link[deSolve]{deSolve}}.
}
\note{
This method can only be used after \code{\link{compile}} has been
  called.

The \code{...} argument should \emph{not} be used to assign values to any of 
  \code{y}, \code{parms}, \code{times}, \code{func}. If \code{fortran} is
  \code{TRUE} it should also not assign values to \code{dllname}, 
  \code{nout}, or \code{outnames}. All these arguments of
  \code{\link[deSolve]{ode}} get their appropriate values automatically.
}
\seealso{
Use \code{\link{step}} for integration over a single time step
  with a built-in, Fortran-based solver.
}
\author{
\email{david.kneis@tu-dresden.de}
}
