% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_workspace.R
\name{save_workspace}
\alias{save_workspace}
\title{Save your justifications to a file}
\usage{
save_workspace(
  file = rock::opts$get("justificationFile"),
  encoding = rock::opts$get("encoding"),
  append = FALSE,
  preventOverwriting = rock::opts$get("preventOverwriting"),
  silent = rock::opts$get("silent")
)
}
\arguments{
\item{file}{If specified, the file to export the justification to.}

\item{encoding}{The encoding to use when writing the file.}

\item{append}{Whether to append to the file, or replace its contents.}

\item{preventOverwriting}{Whether to prevent overwriting an existing file.}

\item{silent}{Whether to be silent or chatty.}
}
\value{
The result of a call to \code{\link[justifier:export_justification]{justifier::export_justification()}}.
}
\description{
When conducting analyses, you make many choices that ideally, you
document and justify. This function saves stored justifications to a
file.
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Get a path to one example file
exampleFile <-
  file.path(examplePath, "example-1.rock");

### Load example source
loadedExample <- rock::load_source(exampleFile);

### Split a code into two codes, showing progress (the backticks are
### used to be able to specify a name that starts with an underscore)
recoded_source <-
  rock::recode_split(
    loadedExample,
    codes="childCode1",
    splitToCodes = list(
      `_and_` = " and ",
      `_book_` = "book",
      `_else_` = TRUE
    ),
    silent=FALSE,
    justification = "Because this seems like a good idea"
  );

### Save this workspace to a file
temporaryFilename <- tempfile();
rock::save_workspace(file = temporaryFilename);
}
