% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmd.R
\name{mmd}
\alias{mmd}
\title{Matrix Mahalanobis distance}
\usage{
mmd(X, mu, cov_row, cov_col, inverted = FALSE)
}
\arguments{
\item{X}{a 3d array of dimension \eqn{(p,q,n)}, containing \eqn{n} matrix-variate samples of \eqn{p} rows and \eqn{q} columns in each slice.}

\item{mu}{a \eqn{p \times q} matrix containing the means.}

\item{cov_row}{a \eqn{p \times p} positive-definite symmetric matrix specifying the rowwise covariance matrix}

\item{cov_col}{a \eqn{q \times q} positive-definite symmetric matrix specifying the columnwise covariance matrix}

\item{inverted}{Logical. FALSE by default.
If TRUE \code{cov_row} and \code{cov_col} are supposed to contain the inverted rowwise and columnwise covariance matrices, respectively.}
}
\value{
Squared Mahalanobis distance(s) of observation(s) in \code{X}.
}
\description{
Matrix Mahalanobis distance
}
\examples{
n = 1000; p = 2; q = 3
mu = matrix(rep(0, p*q), nrow = p, ncol = q)
cov_row = matrix(c(1,0.5,0.5,1), nrow = p, ncol = p)
cov_col = matrix(c(3,2,1,2,3,2,1,2,3), nrow = q, ncol = q)
X <- rmatnorm(n = 1000, mu, cov_row, cov_col)
ind <- sample(1:n, 0.3*n)
X[,,ind] <- rmatnorm(n = length(ind), matrix(rep(10, p*q), nrow = p, ncol = q), cov_row, cov_col)
distances <- mmd(X, mu, cov_row, cov_col)
plot(distances)
abline(h = qchisq(0.99, p*q), lty = 2, col = "red")
}
