% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier_tests.R
\name{multi_cutoff}
\alias{multi_cutoff}
\title{Multiple models, varying cut-off}
\usage{
multi_cutoff(gamma, ...)
}
\arguments{
\item{gamma}{A numeric vector representing the probability of falsely
classifying an observation as an outlier. One setting of the algorithm per
element of \code{gamma} is being run.}

\item{...}{Arguments for specifying the other settings of the outlier
detection algorithm, \code{\link{outlier_detection}}.}
}
\value{
A list containing the \code{robust2sls} objects, one per setting of
\code{gamma}. The length of the list therefore corresponds to the length of
the vector \code{gamma}.
}
\description{
\code{multi_cutoff()} runs several outlier detection algorithms that differ
in the value of the cut-off that determines whether an observation is
classified as an outlier or not.
}
\details{
\code{mutli_cutoff} uses the
  \code{\link[foreach:foreach-package]{foreach}} and
  \code{\link[future:future]{future}} packages to run several models at the
  same time in parallel. This means the user has to register a backend and
  thereby determine how the code should be executed. The default is
  sequential, i.e. not in parallel. See
  \code{\link[future:plan]{future::plan()}} for details.
}
