% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kld.measure_function.R
\name{kld_measure}
\alias{kld_measure}
\title{Function for the Kullback-Leibler Divergence of two normally distributed
treatment effects for the same pairwise comparison}
\usage{
kld_measure(mean_y, sd_y, mean_x, sd_x)
}
\arguments{
\item{mean_y}{A real number that refers to the mean of the estimated
treatment effect Y on the scale of the selected effect measure
(in logarithmic scale for relative effect measures).}

\item{sd_y}{A positive integer that refers to the posterior standard
deviation or the standard error of the estimated treatment effect Y on the
scale of the selected effect measure (in logarithmic scale for relative
effect measures).}

\item{mean_x}{A real number that refers to the mean of the estimated
treatment effect X on the scale of the selected effect measure
(in logarithmic scale for relative effect measures).}

\item{sd_x}{A positive integer that refers to the posterior standard
deviation or the standard error of the estimated treatment effect X on the
scale of the selected effect measure (in logarithmic scale for relative
effect measures).}
}
\value{
The function return the following numeric results:
\tabular{ll}{
   \strong{kld_sym} \tab The symmetric KLD value as the average of two KLD
   values .\cr
   \tab \cr
   \strong{kld_x_true} \tab The KLD value when approximating X by Y
   (X is the 'truth').\cr
   \tab \cr
   \strong{kld_y_true} \tab The KLD value when approximating Y by X
   (Y is the 'truth').\cr
  }
}
\description{
The user specify the (posterior) mean and standard error (or posterior
standard deviation) of two estimated treatment effects, X and Y, that refer
to the \strong{same} pairwise comparison and are assumed to follow a normal
distribution. The function returns the Kullback-Leibler Divergence (KLD)
measure of 1) approximating X with Y, 2) approximating Y with X, and 3) their
average.
}
\references{
Kullback S, Leibler RA. On information and sufficiency.
\emph{Ann Math Stat} 1951;\bold{22}(1):79--86. doi: 10.1214/aoms/1177729694
}
\seealso{
\code{\link{kld_inconsistency}},
  \code{\link{kld_inconsistency_user}}, \code{\link{robustness_index}},
  \code{\link{robustness_index_user}}
}
