## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = FALSE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(rmonocypher)

## -----------------------------------------------------------------------------
# When no salt is provided, a salt will be 
# derived internally from the password. 
argon2("my secret")
# Use another password as the salt
argon2("my secret", salt = "salt and vinegar")
# Use a 32-character hexadecimal string as the salt
argon2("my secret", salt = "cefca6aafae5bdbc15977fd56ea7f1eb")
# Use 'rbyte()' to source 16 random bytes for the salt
salt <- rbyte(16)
argon2("my secret", salt = salt)

## -----------------------------------------------------------------------------
key <- rbyte(32, type = 'raw')
key

## -----------------------------------------------------------------------------
key <- rbyte(32, type = 'chr')
key

