% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pilltabs.R
\name{pilltabs}
\alias{pilltabs}
\title{Given a cross-table, outputs HTML code to display several views of with a tabbed interface}
\usage{
pilltabs(
  tab,
  count = TRUE,
  rows = TRUE,
  cols = TRUE,
  chisq = TRUE,
  resid = TRUE,
  row.names = TRUE
)
}
\arguments{
\item{tab}{a two dimensions table object}

\item{count}{whether or not to display the count table}

\item{rows}{whether or not to display the row percentages table}

\item{cols}{whether or not to display the column percentages table}

\item{chisq}{whether or not to display the table chi-squared test results}

\item{resid}{whether or not to display the chi-squared residuals table}

\item{row.names}{whether or not to display the table row names}
}
\value{
No value is returned.
}
\description{
Given a two dimensions contingency table, this function outputs HTML code to display,
within a dynamic tabbed interface, the count, row percentages, column percentages and
chi-squared residuals tables.
}
\details{
The function is intended to be called inside an rmarkdown document.
}
\examples{

data(airquality)
tab <- table(airquality$Month, airquality$Ozone > 25)
pilltabs(tab)

}
