% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arima.R
\name{ucarima_wk}
\alias{ucarima_wk}
\title{Wiener Kolmogorov Estimators}
\usage{
ucarima_wk(ucm, cmp, signal = TRUE, nspectrum = 601, nwk = 300)
}
\arguments{
\item{ucm}{An UCARIMA model returned by \code{\link[=ucarima_model]{ucarima_model()}}.}

\item{cmp}{Index of the component for which we want to compute the filter}

\item{signal}{TRUE for the signal (component), FALSE for the noise (complement)}

\item{nspectrum}{Number of points used to compute the (pseudo-) spectrum of the estimator}

\item{nwk}{Number of weights of the Wiener-Kolmogorov filter returned in the result}
}
\value{
A list with the (pseudo-)spectrum, the weights of the filter and the
squared-gain function (with the same number of points as the spectrum)
}
\description{
Wiener Kolmogorov Estimators
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
mod1 <- arima_model("trend", delta = c(1, -2, 1))
mod2 <- arima_model("noise", var = 1600)
hp <- ucarima_model(components = list(mod1, mod2))
wk1 <- ucarima_wk(hp, 1, nwk = 50)
wk2 <- ucarima_wk(hp, 2)
plot(wk1$filter, type = "h")
\dontshow{\}) # examplesIf}
}
