% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arima.R
\name{ucarima_estimate}
\alias{ucarima_estimate}
\title{Estimate UCARIMA Model}
\usage{
ucarima_estimate(x, ucm, stdev = TRUE)
}
\arguments{
\item{x}{Univariate time series}

\item{ucm}{An UCARIMA model returned by \code{\link[=ucarima_model]{ucarima_model()}}.}

\item{stdev}{TRUE if standard deviation of the components are computed}
}
\value{
A matrix containing the different components and their standard
deviations if stdev is TRUE.
}
\description{
Estimate UCARIMA Model
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
mod1 <- arima_model("trend", delta = c(1, -2, 1))
mod2 <- arima_model("noise", var = 16)
hp <- ucarima_model(components = list(mod1, mod2))
s <- log(aggregate(Retail$AutomobileDealers))
all <- ucarima_estimate(s, hp, stdev = TRUE)
plot(s, type = "l")
t <- ts(all[, 1], frequency = frequency(s), start = start(s))
lines(t, col = "blue")
\dontshow{\}) # examplesIf}
}
