/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.regression;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.calendars.DayClustering;
import jdplus.toolkit.base.api.timeseries.calendars.TradingDaysType;
import jdplus.toolkit.base.api.timeseries.regression.GenericTradingDaysVariable;
import jdplus.toolkit.base.api.timeseries.regression.ISystemVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITradingDaysVariable;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class HolidaysCorrectedTradingDays
implements ITradingDaysVariable,
ISystemVariable {
    @NonNull
    private final HolidaysCorrector corrector;
    @NonNull
    private final DayClustering clustering;
    private final boolean contrast;
    private final boolean weighted;

    public static Builder builder() {
        return new Builder().clustering(DayClustering.TD7).contrast(true).weighted(false);
    }

    @Override
    public int dim() {
        int n = this.clustering.getGroupsCount();
        return this.contrast ? n - 1 : n;
    }

    @Override
    public TradingDaysType getTradingDaysType() {
        return this.clustering.getType();
    }

    @Override
    public <D extends TimeSeriesDomain<?>> String description(D context) {
        return "Trading days";
    }

    @Override
    public <D extends TimeSeriesDomain<?>> String description(int idx, D context) {
        return GenericTradingDaysVariable.description(this.clustering, idx);
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        return new Builder().corrector(this.corrector).clustering(this.clustering).contrast(this.contrast).weighted(this.weighted);
    }

    @NonNull
    @Generated
    public HolidaysCorrector getCorrector() {
        return this.corrector;
    }

    @NonNull
    @Generated
    public DayClustering getClustering() {
        return this.clustering;
    }

    @Generated
    public boolean isContrast() {
        return this.contrast;
    }

    @Generated
    public boolean isWeighted() {
        return this.weighted;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HolidaysCorrectedTradingDays)) {
            return false;
        }
        HolidaysCorrectedTradingDays other = (HolidaysCorrectedTradingDays)o;
        if (this.isContrast() != other.isContrast()) {
            return false;
        }
        if (this.isWeighted() != other.isWeighted()) {
            return false;
        }
        HolidaysCorrector this$corrector = this.getCorrector();
        HolidaysCorrector other$corrector = other.getCorrector();
        if (this$corrector == null ? other$corrector != null : !this$corrector.equals(other$corrector)) {
            return false;
        }
        DayClustering this$clustering = this.getClustering();
        DayClustering other$clustering = other.getClustering();
        return !(this$clustering == null ? other$clustering != null : !((Object)this$clustering).equals(other$clustering));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isContrast() ? 79 : 97);
        result = result * 59 + (this.isWeighted() ? 79 : 97);
        HolidaysCorrector $corrector = this.getCorrector();
        result = result * 59 + ($corrector == null ? 43 : $corrector.hashCode());
        DayClustering $clustering = this.getClustering();
        result = result * 59 + ($clustering == null ? 43 : ((Object)$clustering).hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "HolidaysCorrectedTradingDays(corrector=" + String.valueOf(this.getCorrector()) + ", clustering=" + String.valueOf(this.getClustering()) + ", contrast=" + this.isContrast() + ", weighted=" + this.isWeighted() + ")";
    }

    @Generated
    public HolidaysCorrectedTradingDays(@NonNull HolidaysCorrector corrector, @NonNull DayClustering clustering, boolean contrast, boolean weighted) {
        if (corrector == null) {
            throw new NullPointerException("corrector is marked non-null but is null");
        }
        if (clustering == null) {
            throw new NullPointerException("clustering is marked non-null but is null");
        }
        this.corrector = corrector;
        this.clustering = clustering;
        this.contrast = contrast;
        this.weighted = weighted;
    }

    @Generated
    public static class Builder {
        @Generated
        private HolidaysCorrector corrector;
        @Generated
        private DayClustering clustering;
        @Generated
        private boolean contrast;
        @Generated
        private boolean weighted;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder corrector(@NonNull HolidaysCorrector corrector) {
            if (corrector == null) {
                throw new NullPointerException("corrector is marked non-null but is null");
            }
            this.corrector = corrector;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clustering(@NonNull DayClustering clustering) {
            if (clustering == null) {
                throw new NullPointerException("clustering is marked non-null but is null");
            }
            this.clustering = clustering;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder contrast(boolean contrast) {
            this.contrast = contrast;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder weighted(boolean weighted) {
            this.weighted = weighted;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull HolidaysCorrectedTradingDays build() {
            return new HolidaysCorrectedTradingDays(this.corrector, this.clustering, this.contrast, this.weighted);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "HolidaysCorrectedTradingDays.Builder(corrector=" + String.valueOf(this.corrector) + ", clustering=" + String.valueOf(this.clustering) + ", contrast=" + this.contrast + ", weighted=" + this.weighted + ")";
        }
    }

    public static interface HolidaysCorrector {
        public Matrix rawCorrection(TsDomain var1);

        public Matrix holidaysCorrection(TsDomain var1);

        public DoubleSeq longTermYearlyCorrection();
    }
}

