/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.basic;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;

public class TimeInvariantDynamics
implements ISsfDynamics {
    private final FastMatrix T;
    private final FastMatrix V;
    private transient FastMatrix S;
    private static final String FMT = "0.#####";

    public TimeInvariantDynamics(FastMatrix T2, Innovations E) {
        this.T = T2;
        this.S = E.S;
        this.V = E.V;
    }

    public static TimeInvariantDynamics of(int stateDim, ISsfDynamics sd) {
        if (!sd.isTimeInvariant()) {
            return null;
        }
        FastMatrix t = FastMatrix.square(stateDim);
        sd.T(0, t);
        Innovations e = Innovations.of(stateDim, sd);
        if (e == null) {
            return null;
        }
        return new TimeInvariantDynamics(t, e);
    }

    private synchronized void checkS() {
        if (this.S == null) {
            this.S = this.V.deepClone();
            SymmetricMatrix.lcholesky(this.S);
        }
    }

    @Override
    public boolean isTimeInvariant() {
        return true;
    }

    @Override
    public boolean areInnovationsTimeInvariant() {
        return true;
    }

    @Override
    public int getInnovationsDim() {
        return this.S == null ? this.T.getColumnsCount() : this.S.getColumnsCount();
    }

    @Override
    public void V(int pos, FastMatrix qm) {
        qm.copy(this.V);
    }

    @Override
    public boolean hasInnovations(int pos) {
        return this.V != null;
    }

    @Override
    public void S(int pos, FastMatrix sm) {
        this.checkS();
        sm.copy(this.S);
    }

    @Override
    public void addSU(int pos, DataBlock x, DataBlock u) {
        this.checkS();
        x.addProduct(this.S.rowsIterator(), u);
    }

    @Override
    public void XS(int pos, DataBlock x, DataBlock xs) {
        this.checkS();
        xs.product(x, this.S.columnsIterator());
    }

    @Override
    public void T(int pos, FastMatrix tr) {
        tr.copy(this.T);
    }

    @Override
    public void TM(int pos, FastMatrix tm) {
        DataBlock tx = DataBlock.make(this.T.getColumnsCount());
        DataBlockIterator cols = tm.columnsIterator();
        while (cols.hasNext()) {
            DataBlock col = cols.next();
            tx.product(this.T.rowsIterator(), col);
            col.copy(tx);
        }
    }

    @Override
    public void TVT(int pos, FastMatrix tvt) {
        FastMatrix V = tvt.deepClone();
        SymmetricMatrix.XSXt(V, this.T, tvt);
    }

    @Override
    public void TX(int pos, DataBlock x) {
        DataBlock tx = DataBlock.make(x.length());
        tx.product(this.T.rowsIterator(), x);
        x.copy(tx);
    }

    @Override
    public void XT(int pos, DataBlock x) {
        DataBlock tx = DataBlock.make(x.length());
        tx.product(x, this.T.columnsIterator());
        x.copy(tx);
    }

    @Override
    public void addV(int pos, FastMatrix p) {
        p.add(this.V);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("T:\r\n").append(this.T.toString(FMT)).append(System.lineSeparator());
        builder.append("V:\r\n").append(this.V.toString(FMT)).append(System.lineSeparator());
        return builder.toString();
    }

    public static class Innovations {
        public final FastMatrix S;
        public final FastMatrix V;

        private static Innovations of(int stateDim, ISsfDynamics sd) {
            int ne = sd.getInnovationsDim();
            FastMatrix V = FastMatrix.square(stateDim);
            sd.V(0, V);
            FastMatrix S = FastMatrix.make(stateDim, ne);
            sd.S(0, S);
            return new Innovations(V, S);
        }

        public Innovations(FastMatrix V) {
            this.V = V;
            this.S = null;
        }

        public Innovations(FastMatrix V, FastMatrix S) {
            this.S = S;
            this.V = V == null && S != null ? SymmetricMatrix.XXt(S) : V;
        }
    }
}

