/*
 * Decompiled with CFR 0.152.
 */
package internal.io.text;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.Resource;
import nbbrd.io.function.IOFunction;
import nbbrd.io.text.TextParser;
import nbbrd.io.text.TextResource;

public final class FunctionalTextParser<T>
implements TextParser<T> {
    @NonNull
    private final IOFunction<? super Reader, ? extends T> function;

    @Override
    @NonNull
    public T parseReader(@NonNull Reader resource) throws IOException {
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        return this.doParse(TextResource.uncloseableReader(resource));
    }

    @Override
    @NonNull
    public T parseStream(@NonNull InputStream resource, @NonNull Charset encoding) throws IOException {
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        if (encoding == null) {
            throw new NullPointerException("encoding is marked non-null but is null");
        }
        try (InputStreamReader reader = new InputStreamReader(Resource.uncloseableInputStream(resource), encoding);){
            T t = this.doParse(reader);
            return t;
        }
    }

    private T doParse(Reader reader) throws IOException {
        return Objects.requireNonNull(this.function.applyWithIO(reader), "result");
    }

    @Generated
    public FunctionalTextParser(@NonNull IOFunction<? super Reader, ? extends T> function) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        this.function = function;
    }
}

