% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivs.R
\name{rxp_rmd}
\alias{rxp_rmd}
\title{Render an R Markdown Document as a Nix Derivation}
\usage{
rxp_rmd(
  name,
  rmd_file,
  additional_files = "",
  nix_env = "default.nix",
  params = NULL,
  env_var = NULL,
  noop_build = FALSE
)
}
\arguments{
\item{name}{Symbol, derivation name.}

\item{rmd_file}{Character, path to .Rmd file.}

\item{additional_files}{Character vector, additional files to include, for
example a folder containing the pictures to include in the R Markdown
document.}

\item{nix_env}{Character, path to the Nix environment file, default is
"default.nix".}

\item{params}{List, parameters to pass to the R Markdown document. Default is
NULL.}

\item{env_var}{List, defaults to NULL. A named list of environment variables
to set before running the R Markdown render command, e.g., c(RSTUDIO_PANDOC
= "/path/to/pandoc"). Each entry will be added as an export statement in
the build phase.}

\item{noop_build}{Logical, defaults to FALSE. If TRUE, the derivation
produces a no-op build (a stub output with no actual build steps). Any
downstream derivations depending on a no-op build will themselves also
become no-op builds.}
}
\value{
An object of class derivation which inherits from lists.
}
\description{
Render an R Markdown Document as a Nix Derivation
}
\details{
To include objects built in the pipeline,
\code{rxp_read("derivation_name")} should be put in the .Rmd file.
}
\examples{
\dontrun{
  # Compile a .Rmd file to a pdf
  # `images` is a folder containing images to include in the R Markdown doc
  rxp_rmd(
    name = report,
    rmd_file = "report.Rmd",
    additional_files = "images"
  )

  # Skip building this derivation
  rxp_rmd(
    name = draft_report,
    rmd_file = "draft.Rmd",
    noop_build = TRUE
  )
}
}
\seealso{
Other derivations: 
\code{\link{rxp_jl}()},
\code{\link{rxp_jl_file}()},
\code{\link{rxp_py}()},
\code{\link{rxp_py_file}()},
\code{\link{rxp_qmd}()},
\code{\link{rxp_r}()},
\code{\link{rxp_r_file}()}
}
\concept{derivations}
